const ShopNumberSubWindow = require('../shop/ShopNumberSubWindow');

//-----------------------------------------------------------------------------
// Window_StoreNumber

class Window_StoreNumber extends ShopNumberSubWindow {
  initialize() {
    const width = this.windowWidth();
    const height = this.windowHeight();

    const x = (Graphics.width - width) / 2;
    const y = (Graphics.height - height) / 2;

    super.initialize(x, y);
    this._imageBackground = Managers.Images.loadBackground(this.backgroundImageName());
  }

  backgroundImageName() {
    return 'layout_number_popup';
  }

  windowWidth() {
    return 116 * Graphics.windowZoomLevel;
  }

  windowHeight() {
    return 85 * Graphics.windowZoomLevel;
  }

  setup(item, max) {
    this._item = item;
    this._max = Math.floor(max);
    this._number = this._max;

    this.placeButtons();
    this.updateButtonsVisibility();
    this.changeNumber(0);
    this.refresh();
  }

  setUnitMultiplierForItem(item) {
    this._unitMultiplier = 1;
  }

  drawContentBackground() {
    if (this._imageBackground.isReady()) {
      const w = this._imageBackground.width;
      const h = this._imageBackground.height;

      const dW = w * this._zoomLevel;
      const dH = h * this._zoomLevel;

      this.contents.bltImage(this._imageBackground, 0, 0, w, h, 0, 0, dW, dH);
    } else {
      this.requireBitmap(this._imageBackground);
    }
  }

  drawTotalPrice() {
  }

  drawSelectedItemName() {
  }

  topMargin() {
    return 15 * Graphics.windowZoomLevel;
  }

  leftMargin() {
    return 15 * Graphics.windowZoomLevel;
  }

  placeButtons() {
    super.placeButtons();

    const z = Graphics.windowZoomLevel;
    const left = this.leftMargin();

    this._buttons[0].x = left + 27 * z;
    this._buttons[1].x = left + 43 * z;
  }

  drawSelectedItemIcon() {
    const x = this.getIconX();
    const y = this.getIconY();

    this.drawIcon(this._item.iconIndex, x, y);
  }
}

module.exports = Window_StoreNumber;