const Window_Command = require('engine/windows/Window_Command');
//-----------------------------------------------------------------------------
// Window_ItemCategory
//
// The window for selecting a category of items on the storage screen.

class Window_ItemCategory extends Window_Command {
  initialize(x, y) {
    super.initialize(x, y);
  }

  enableWindowFrame() {
    return false;
  }

  extraSpacing() {
    return 0;
  }

  standardPadding() {
    return 0;
  }

  spacing() {
    return 0;
  }

  windowWidth() {
    return 26 * Graphics.windowZoomLevel;
  }

  windowHeight() {
    return 220 * Graphics.windowZoomLevel;
  }

  maxCols() {
    return 1;
  }

  lineHeight() {
    return 31 * Graphics.windowZoomLevel;
  }

  enableCursorSprite() {
    return false;
  }

  update() {
    super.update();
    if (this._itemWindow) {
      this._itemWindow.setCategory(this.currentSymbol());
    }

    this.refresh();
  }

  drawItem(index) {
    const rect = this.itemRectForText(index);

    if (this._list[index]) {
      const iconName = this.getSymbol(index);
      let bitmapName;
      let x = 0;

      if (index === this.index()) {
        bitmapName = `icon_${ iconName }_on`;
      } else {
        bitmapName = `icon_${ iconName }_off`;
        x = 4;
      }

      const zoom = Graphics.windowZoomLevel;
      this.drawPicture(`storage/${ bitmapName }`, rect.x + x * zoom, rect.y, zoom);
    }
  }

  itemTextAlign() {
    return 'left';
  }

  addCategory(text, symbol, iconIndex) {
    this.addCommand(text, symbol, true, iconIndex);
  }

  makeCommandList() {
    this.addCategory('', 'all');
    this.addCategory('', 'crops');
    this.addCategory('', 'tools');
    this.addCategory('', 'material');
    this.addCategory('', 'food');
    this.addCategory('', 'fish');
    this.addCategory('', 'loot');
  }

  setItemWindow(itemWindow) {
    this._itemWindow = itemWindow;
    this.update();
  }

  select(index) {
    super.select(index);

    if (this._itemWindow) {
      this._itemWindow.setCategory(this.currentSymbol());
    }
  }
}

module.exports = Window_ItemCategory;
