const Window_Base = require('engine/windows/Window_Base');

class Window_ContainerSummary extends Window_Base {
  initialize(x, y, width, height) {
    super.initialize(x, y, width, height);
    this._zoomLevel = Graphics.windowZoomLevel;

    this._imageBackground = Managers.Images.loadBackground('box_text');
    this._text = '';
  }

  enableWindowFrame() {
    return false;
  }

  drawBackground() {
    if (!this._imageBackground.isReady()) {
      this.requireBitmap(this._imageBackground);
      return;
    }

    const w = this._imageBackground.width;
    const h = this._imageBackground.height;

    const dW = w * this._zoomLevel;
    const dH = h * this._zoomLevel;

    this.contents.bltImage(this._imageBackground, 0, 0, w, h, 0, 0, dW, dH);
  }

  setText(text) {
    if (this._text !== text) {
      this._text = text;
      this.refresh();
    }
  }

  clear() {
    this.setText('');
  }

  standardPadding() {
    return 0;
  }

  textPadding() {
    return 10 * this._zoomLevel;
  }

  drawContent() {
    this.drawTextEx(`<WordWrap>${this._text}`, this.textPadding(), 0);
  }

  resetTextColor() {
    this.changeTextColor('#3d2b25');
  }

  resetFontSettings() {
    super.resetFontSettings();
    this.contents.outlineWidth = 0;
  }

  refresh() {
    if (this.contents) {
      this.contents.clear();
      this.drawBackground();
      this.drawContent();
    }
  }
}

module.exports = Window_ContainerSummary;