const Window_Base = require('engine/windows/Window_Base');

class Window_ContainerBackground extends Window_Base {
  initialize(x, y, width, height, xOffset, yOffset, backgroundName) {
    super.initialize(x, y, width, height);
    this._zoomLevel = Graphics.windowZoomLevel;
    this._xOffset = xOffset;
    this._yOffset = yOffset;

    this._imageBackground = Managers.Images.loadBackground(backgroundName);
    this._exitMenuBitmap = Managers.Images.loadPicture('menu/exit_menu2');
  }

  enableWindowFrame() {
    return false;
  }

  drawContent() {
    if (this._imageBackground.isReady()) {
      const w = this._imageBackground.width;
      const h = this._imageBackground.height;

      const dW = w * this._zoomLevel;
      const dH = h * this._zoomLevel;

      this.contents.bltImage(this._imageBackground, 0, 0, w, h, this._xOffset, this._yOffset, dW, dH);
    } else {
      this.requireBitmap(this._imageBackground);
    }

    if (this._exitMenuBitmap.isReady()) {
      const buttonX = this._xOffset + 329 * this._zoomLevel;
      const buttonY = this._yOffset + 18 * this._zoomLevel;
      const buttonW = this._exitMenuBitmap.width * this._zoomLevel;
      const buttonH = this._exitMenuBitmap.height * this._zoomLevel;

      this.contents.bltImage(this._exitMenuBitmap, 0, 0, this._exitMenuBitmap.width, this._exitMenuBitmap.height, buttonX, buttonY, buttonW, buttonH);
    } else {
      this.requireBitmap(this._exitMenuBitmap);
    }
  }

  isMouseOverCloseButton() {
    const bitmap = this._exitMenuBitmap;
    if (!bitmap.isReady()) {
      return false;
    }

    const zoom = this._zoomLevel;
    const mouseX = (TouchInput.mouseX - this.x - this._xOffset) / zoom;
    const mouseY = (TouchInput.mouseY - this.y - this._yOffset) / zoom;

    if (mouseY < 18) return false;
    if (mouseX < 329) return false;
    if (mouseY > (18 + bitmap.height)) return false;
    if (mouseX > (329 + bitmap.width)) return false;

    return true;
  }

  standardPadding() {
    return 0;
  }

  refresh() {
    if (this.contents) {
      this.contents.clear();
      this.drawContent();
    }
  }
}

module.exports = Window_ContainerBackground;