const Window_ItemBase = require('./Window_ItemBase');

//-----------------------------------------------------------------------------
// Window_ToolContainer
//
// Displays the player's tools

class Window_ToolContainer extends Window_ItemBase {
  initialize(x, y, width, height) {
    this._items = Managers.Tools.tools(true);
    if (this.includeEmptyItem) {
      this._items.push('empty');
    }
    this._index = -1;
    super.initialize(x, y, width, height);
  }

  maxItems() {
    return this._items.length;
  }

  includeEmptyItem() {
    return true;
  }

  item() {
    return this.getItem(this.index());
  }

  getItem(index) {
    if (this._items && index >= 0) return this._items[index];

    return {
      id : '',
      amount : 1
    };
  }

  refresh() {
    this.createContents();
    this.drawAllItems();

    this.drawSelectedItem();

    this._needsRefresh = false;
  }

  update() {
    super.update();
    if (this._needsRefresh) {
      this.refresh();
    }
  }

  drawItemBgPicture(item, x, y, zoomLevel, index) {
    const id = item == 'empty' ? item : item.id;
    const equippedId = Managers.Tools.toolId ? Managers.Tools.toolId : 'empty';

    if (id == equippedId) {
      this.drawPicture('toolHud/selected', x, y, zoomLevel, true);
    } else {
      this.drawPicture('toolHud/empty', x, y, zoomLevel, true);
    }
  }

  drawSelectedItem() {
    const index = this.index();
    if (index < 0) return;

    const rect = this.itemRect(index);
    const item = this.getItem(index);
    this.drawNormalItem(item, rect.x, rect.y, true, index);
  }

  drawEmptyItem(x, y, zoomLevel, index) {
    if (Managers.Tools.toolId && Managers.Tools.toolId !== 'empty') {
      super.drawEmptyItem(x, y, zoomLevel, index);
      return;
    }

    if (zoomLevel === undefined) zoomLevel = 1;
    this.drawPicture('toolHud/selected', x + this.extraSpacing(), y + this.extraSpacing(), zoomLevel, true);
  }

  drawItem(index) {
    if (index == this.index()) return;

    const item = this.getItem(index);
    if (item) {
      const rect = this.itemRect(index);
      rect.width -= this.textPadding();

      this.drawNormalItem(item, rect.x, rect.y, false, index);
    }
  }

  itemWidth() {
    return this.lineHeight();
  }

  itemHeight() {
    return this.lineHeight();
  }

  lineHeight() {
    return 52;
  }

  maxCols() {
    return Math.floor((this.width - (this.padding + this.extraSpacing()) * 2) / this.itemWidth());
  }

  spacing() {
    return 0;
  }

  updateCursor() {
    this._needsRefresh = true;
  }

  updateHelp() {
    this.setHelpWindowItem(this.item());
  }

  callUpdateHelp() {
    if (this._helpWindow) {
      this.updateHelp();
    }
  }

  extraSpacing() {
    return 24;
  }
}

module.exports = Window_ToolContainer;
