const Window_ItemBase = require('./Window_ItemBase');

//-----------------------------------------------------------------------------
// Window_ShopBuy
//
// The window for selecting an item to buy on the shop screen.

class Window_ShopBuy extends Window_ItemBase {
  initialize(x, y, width, height, shopGoods) {
    super.initialize(x, y, width, height);
    this._shopGoods = shopGoods;
    this._money = 0;
    this.refresh();
    this.select(0);
  }

  maxItems() {
    return this._data ? this._data.length : 1;
  }

  setMoney(money) {
    this._money = money;
    this.refresh();
  }

  isCurrentItemEnabled() {
    return this.isEnabled(this._data[this.index()]);
  }

  price(item) {
    return Managers.Items.getBuyPrice(item);
  }

  item() {
    return this.getItem(this.index());
  }

  isEnabled(item) {
    return (item && this.price(item) <= this._money && !Managers.Items.hasMaxItems(item));
  }

  refresh() {
    this.makeItemList();
    this.createContents();
    this.drawAllItems();
  }

  makeItemList() {
    this._data = [];
    this._shopGoods.forEach(function(itemId) {
      const item = Managers.Items.getItemData(itemId);

      if (item) {
        //#ToDo: Check if item is unlocked
        this._data.push(item);
      }
    }, this);
  }

  drawItem(index) {
    const item = this.getItem(index);

    if (item) {
      const rect = this.itemRect(index);
      rect.width -= this.textPadding();

      this.changePaintOpacity(this.isEnabled(item));
      this.drawNormalItem(item, rect.x + 10, rect.y, false, index);
      const lineHeight = this.lineHeight();
      this.drawText(this.price(item) + Managers.Text.currencyUnit, rect.x + 10, rect.y + (rect.height - lineHeight) / 2, rect.width - 10, 'right');
      this.changePaintOpacity(true);
    }
  }

  setStatusWindow(statusWindow) {
    this._statusWindow = statusWindow;
    this.callUpdateHelp();
  }

  updateHelp() {
    this.setHelpWindowItem(this.item());
    if (this._statusWindow) {
      this._statusWindow.setItem(this.item());
    }
  }

  getItem(index) {
    return this._data && index >= 0 ? Managers.Items.findItem(this._data[index].id) : '';
  }

  itemHeight() {
    return 52;
  }

  maxCols() {
    return 4;
  }

  extraSpacing() {
    return 0;
  }

  standardPadding() {
    return 18;
  }
}

module.exports = Window_ShopBuy;
