const Window_Base = require('engine/windows/Window_Base');

//-----------------------------------------------------------------------------
// Window_Letter
//
// The window for displaying on screen letters

class Window_Letter extends Window_Base {
  initialize() {
    const width = 538;
    const height = 385;
    const x = Graphics.width / 2 - width / 2;
    const y = Graphics.height / 2 - height / 2;
    this._text = '';

    super.initialize(x, y, width, height);

    this.opacity = 0;
    this.refresh();
  }

  setup(text) {
    this._text = text;
    this.show();
    this.refresh();
  }

  refresh() {
    this.drawSystem('Letter');
    this.resetFontSettings();
    this.drawTextEx(`<WordWrap>${this._text}`, 25, 31);
  }

  standardBackOpacity() {
    return 0;
  }

  standardPadding() {
    return 0;
  }

  standardFontSize() {
    return 17;
  }


  resetFontSettings() {
    super.resetFontSettings();

    this.contents.outlineColor = 'rgba(255, 255, 255, 0)';
    this.contents.fontFace = this.standardFontFace();
    this.contents.fontFamily = this.standardFontFace();
    this.contents.outlineWidth = 0;
  }

  lineHeight() {
    return 25;
  }

  standardFontFace() {
    return 'LetterFont';
  }

  extraLineHeight() {
    return 8;
  }

  normalColor() {
    return this.blackColor();
  }
}

module.exports = Window_Letter;
