const Window_Selectable = require('engine/windows/Window_Selectable');
const Window_Base = require('engine/windows/Window_Base');
//-----------------------------------------------------------------------------
// Window_ItemBase
//
// A selectable window capable of rendering items

class Window_ItemBase extends Window_Selectable {
  drawEmptyItem(x, y, zoomLevel/*, index*/) {
    if (zoomLevel === undefined) zoomLevel = 1;

    this.drawPicture('toolHud/empty', x + this.extraSpacing(), y + this.extraSpacing(), zoomLevel);
  }

  getItemAmount(item) {
    return item.amount;
  }

  drawItemBgPicture(item, x, y, zoomLevel, index) {
    this.drawPicture('toolHud/empty', x, y, zoomLevel);
  }

  drawNormalItem(item, x, y, zoomedIn, index) {
    if (zoomedIn === undefined) zoomedIn = false;

    let zoomLevel = 1;
    let w = Window_Base._iconWidth;
    let h = Window_Base._iconHeight;

    if (zoomedIn) {
      x -= 13;
      y -= 13;
      zoomLevel = 1.5;
    } else {
      w = Math.floor(w / 1.23);
      h = Math.floor(h / 1.23);
    }

    if (!!item && !!item.id) {
      x += this.extraSpacing();
      y += this.extraSpacing();
      let iconX = x;
      let iconY = y;

      if (zoomedIn) {
        iconX += 6;
        iconY += 6;
      }

      this.drawItemBgPicture(item, x, y, zoomLevel, index);
      this.drawItemBadge(item.iconIndex, iconX, iconY, w, h);

      const amount = this.getItemAmount(item);
      this.drawItemAmount(amount, x, y, zoomedIn);
    } else {
      this.drawEmptyItem(x, y, zoomLevel, index);
    }
  }

  drawItemAmount(amount, x, y, zoomedIn) {
    if (amount <= 1) {
      return;
    }
    this.contents.outlineColor = 'rgba(0, 0, 0, 1)';
    let numberWidth;

    if (zoomedIn) {
      this.contents.fontSize = 24;
      numberWidth = this.textWidth(amount);
      this.drawText(amount, x + 70 - numberWidth, y + 34, 80, 20, 'right');
    } else {
      this.contents.fontSize = 20;
      numberWidth = this.textWidth(amount);

      this.drawText(amount, x + 52 - numberWidth, y + 14, 46, 20, 'right');
    }
  }

  extraSpacing() {
    return 32;
  }

  standardPadding() {
    return 0;
  }

  getIndexUnderCursor(x, y) {
    if (x < this.x) return false;
    if (y < this.y) return false;

    if (x > this.x + this._width) return false;
    if (y > this.y + this._height) return false;

    const marginX = this.x + this.spacing() - this._scrollX + this.extraSpacing() + this.padding;
    const marginY = this.y + this.extraSpacing() - this._scrollY + this.padding;

    for (let i = 0 ; i < this.maxItems(); i++) {
      const rect = this.itemRect(i);

      if (x < rect.x + marginX) continue;
      if (x > rect.x + marginX + rect.width) continue;
      if (y < rect.y + marginY) continue;
      if (y > rect.y + marginY + rect.height) continue;

      return i;
    }

    return false;
  }

  processMapTouch(x, y) {
    const index = this.getIndexUnderCursor(x, y);
    if (index === false) return;

    this.onClickItem(index);
  }

  onClickItem(index) {
    // Nothing to do by default
  }

  playOkSound() {
  }
}

module.exports = Window_ItemBase;
