const Window_Base = require('engine/windows/Window_Base');

class Window_Hud extends Window_Base {
  drawValueUsingImage(x, y, value, maxWidth, imageName, charW, charH, rightAlignText, hudName, zoomLevel, multiplyZoomLevel = false) {
    const charData = {};
    for (let i = 1; i <= 5; i++) {
      charData[i.toString()] = {
        x : (i-1) * charW,
        y : 0
      };
      charData[((i + 5) % 10 ).toString()] = {
        x : (i-1) * charW,
        y : charH
      };
    }

    charData.$ = {
      x : charW * 5,
      y : 0
    };

    charData[':'] = {
      x : charW * 5,
      y : charH
    };
    charData['+'] = {
      x : charW * 5,
      y : charH
    };

    value = value.toString().split('');

    let charX = x;
    const charY = y;
    const totalWidth = value.length * charW * (multiplyZoomLevel ? zoomLevel : 1);

    if (rightAlignText) {
      if (totalWidth < maxWidth) {
        charX += (maxWidth - totalWidth);
      }
    }

    for (let charIdx = 0; charIdx < value.length; charIdx++) {
      const data = charData[value[charIdx]];
      if (data) {
        this.drawImagePiece(`${hudName}/${imageName}`, charX, charY, data.x, data.y, charW, charH, zoomLevel);
        charX += (charW - 1) * (multiplyZoomLevel ? zoomLevel : 1);
      }
    }
  }
}

module.exports = Window_Hud;