const Window_PopupCommand = require('./core/PopupCommand');
//-----------------------------------------------------------------------------
// Window_GameEnd
//
// The window for selecting "Go to Title" on the game end screen.

class Window_GameEnd extends Window_PopupCommand {
  initialize() {
    super.initialize();
    this.refresh();
  }

  popupBackgroundName() {
    return 'popup3';
  }

  windowHeight() {
    return 100 * Graphics.windowZoomLevel;
  }

  makeCommandList() {
    this.addCommand(t('To Title'), 'toTitle');
    this.addCommand(t('Shutdown'), 'shutdown');
    this.addCommand(t('Cancel'),  'cancel');
  }
}

module.exports = Window_GameEnd;