const Window_Base = require('engine/windows/Window_Base');

class Window_FestivalHud extends Window_Base {
  initialize() {
    super.initialize(0, 0, Graphics.width, Graphics.height);
    this.opacity = 0;
    this.refresh();
  }

  windowWidth() {
    return Graphics.width;
  }

  windowHeight() {
    return Graphics.height;
  }

  standardPadding() {
    return 0;
  }

  refresh() {
    if (!this.shouldBeVisible()) return;

    if (this.contents) {
      this.contents.clear();
      this.drawHud();
    }
  }

  shouldBeVisible() {
    if (!Switches.isInsideFestivalCompetition) return false;

    return true;
  }

  drawHud() {



  }

  valuesChanged() {
    return false;
  }

  update() {
    if (this._isVisible) {
      if (Graphics.skipFrame) return;
      // if (Graphics.fps < 30 && Graphics.skipFrame) return;
    }

    super.update();
    let shouldRefresh = !!this._isDirty;

    if (!this.visible) {
      if (this._isVisible) {
        this.contents.clear();
      }

      this._isVisible = false;
      return;
    }

    if (!this._isVisible) {
      shouldRefresh = true;
    }

    if (this.valuesChanged()) {
      shouldRefresh = true;
    }

    this._isVisible = true;
    this._isDirty = false;

    if (shouldRefresh) {
      this.refresh();
    }
  }

  requestUpdate() {
    this._isDirty = true;
  }

  standardFontFace() {
    if ($gameSystem.isChinese()) {
      return 'SimHei, Heiti TC, sans-serif';
    } else if ($gameSystem.isKorean()) {
      return 'Dotum, AppleGothic, sans-serif';
    } else {
      return 'GameFont';
    }
  }
}

module.exports = Window_FestivalHud;
