const Window_Base = require('engine/windows/Window_Base');
//-----------------------------------------------------------------------------
// Window_DateChange
//
// The window for displaying the date change effect

class Window_DateChange extends Window_Base {
  initialize() {
    const width = Graphics.width;
    const height = Graphics.height;
    super.initialize(0, 0, width, height);

    this._oldDate = '';
    this._newDate = '';
    this._minNewDateY = Graphics.height / 2 - this.lineHeight() / 2;
    this._oldDateY = this._minNewDateY;
    this._newDateY = Graphics.height;
    this._isDone = false;
    this._callback = false;
    this.opacity = 0;
    this.padding = 0;
    this.margin = 0;
  }

  windowWidth() {
    return Graphics.width;
  }

  windowHeight() {
    return Graphics.height;
  }

  standardPadding() {
    return 0;
  }

  standardBackOpacity() {
    return 0;
  }

  update() {
    if (!this._isDone) {
      this.refresh();
    }
  }

  setDates(oldDate, newDate, callback) {
    this._oldDate = oldDate;
    this._newDate = newDate;
    this._oldDateY = this._minNewDateY;
    this._newDateY = Graphics.height;
    this._callback = callback;
    this._isDone = false;
    this._count = 0;
  }

  refresh() {
    this.contents.clear();

    const speed = 1.5 * Graphics.windowZoomLevel / 2;

    this.drawText(this._oldDate, 0, this._oldDateY, Graphics.width, 'center');
    this.drawText(this._newDate, 0, this._newDateY, Graphics.width, 'center');

    if (this._oldDate !== this._newDate) {
      if (this._count > 100) {
        this._oldDateY -= speed;

        if (this._oldDateY < 0) {
          if (this._callback) {
            this._callback();
            this._callback = false;
          }

          if (this._newDateY > this._minNewDateY) {
            this._newDateY -= speed;
          } else {
            this._count++;
            if (this._count > 160) {
              this._isDone = true;
            }
          }
        }
      } else {
        this._count++;
      }
    } else {
      this._count++;

      if (this._callback) {
        this._callback();
        this._callback = false;
      }

      if (this._count > 100) {
        this._oldDateY -= speed;

        if (this._oldDateY < 0) {
          this._isDone = true;
        }
      }
    }
  }
}

module.exports = Window_DateChange;
