
function addMeetEveryoneTask() {
  Managers.Tasks.completeTask('meet-everyone');
}

function changePlayerHousePositions(content) {
  if (!content || !content.farmObjects || !content.farmObjects.farmObjects) {
    return;
  }

  const farmObjects = content.farmObjects.farmObjects;

  if (farmObjects[3]) {
    for (let obj of farmObjects[3]) {
      if (!obj) continue;
      obj.y = 8;
      obj.x = 20;
    }
  }
  if (farmObjects[20]) {
    for (let obj of farmObjects[20]) {
      if (!obj) continue;
      obj.y = 8;
      obj.x = 20;
    }
  }

  if (!Managers.Creatures._creatures) {
    return;
  }

  const creatures = Managers.Creatures._creatures[3];
  if (creatures) {
    for (let creature of creatures) {
      if (!creature) continue;

      creature.x = 17;
      creature.y = 5;

      if (creature.homeMapId == 3) {
        creature.homeX = 17;
        creature.homeY = 5;
      }
    }
  }

  const creaturesEx = Managers.Creatures._creatures[20];
  if (creaturesEx) {
    for (let creature of creaturesEx) {
      if (!creature) continue;

      creature.x = 17;
      creature.y = 5;

      if (creature.homeMapId == 20) {
        creature.homeX = 17;
        creature.homeY = 5;
      }
    }
  }
}
function migrateTalkStageVariables(content) {
  Switches.canShowChloeFoodBurntEvent = Variables.chloeTalkStage >= 5;

  Switches.lucasOpenedUp = Variables.lucasTalkStage >= 5;
  Switches.benjaminOpenedUp = Variables.benjaminTalkStage >= 10;
  Switches.unlockedBenjiHayTask = Variables.benjaminTalkStage >= 4;
  Switches.unlockedCindyEvents = Variables.cindyTalkStage >= 10;
  Switches.unlockedBrittanyEvents = Variables.brittanyTalkStage >= 10;
  Switches.unlockedNathaliaEvents = Variables.nathaliaTalkStage >= 10;
  Switches.unlockedRaphaelEvents = Variables.raphaelTalkStage >= 10;
  Switches.unlockedStellaEvents = Variables.stellaTalkStage >= 10;
  Switches.unlockedViktorEvents = Variables.viktorTalkStage >= 10;
}

function clearReservedHouseSpace(content) {
  const farmObjects = Managers.FarmObjects._farmObjects && Managers.FarmObjects._farmObjects[4];
  const farmCreatures = Managers.Creatures._creatures && Managers.Creatures._creatures[4];

  if (farmObjects) {
    for (let obj of farmObjects) {
      if (!obj) continue;

      if (obj.x >= 28 && obj.x <= 45) {
        if (obj.y >= 3 && obj.y <= 8) {
          obj.x = 30;
          obj.y = 9;
        }
      }
    }
  }

  if (farmCreatures) {
    for (let creat of farmCreatures) {
      if (!creat) continue;

      if (creat.x >= 28 && creat.x <= 40) {
        if (creat.y >= 3 && creat.y <= 8) {
          creat.x = 32;
          creat.y = 9;
        }
      }
      if (creat.homeMapId === 4) {
        if (creat.homeX >= 28 && creat.homeX <= 40) {
          if (creat.homeY >= 3 && creat.homeY <= 8) {
            creat.homeX = 32;
            creat.homeY = 9;
          }
        }
      }
    }
  }
}

function fixCurupiraTask(content) {
  if (Managers.Tasks.getTaskStatus('curupira-task-4') == TaskStatus.ACCEPTED) {
    Managers.Tasks.replaceTask('curupira-task-4', 'curupira-task-5');
  }
}

function countFishCaught() {
  const counts = {};
  const fishNames = [
    'tiger-barb',
    'bass',
    'walleye',
    'pickerel',
    'tuna',
    'dourado',
    'tilapia',
    'traira',
    'pacu',
    'lambari',
    'barbado',
    'piranha-vermelha',
    'truta',
    'jau'
  ];

  let total = 0;
  for (const fishId of fishNames) {
    counts[fishId] = 0;
  }

  Managers.History.iterateHistory((day, month, year) => {
    let dayTotal = 0;
    if (!Managers.History._dailyData || !Managers.History._dailyData[year] || !Managers.History._dailyData[year][month] || !Managers.History._dailyData[year][month][day]) {
      return;
    }

    const data = Managers.History._dailyData[year][month][day];
    if (!data) {
      return;
    }

    for (const fishId of fishNames) {
      const id = `fish-${ fishId}`;
      if (data[id]) {
        counts[fishId] += data[id];
        total += data[id];
        dayTotal += data[id];
      }
    }

    if (dayTotal) {
      data['fish-caught'] = dayTotal;
    }
  });

  for (const fishId of fishNames) {
    if (counts[fishId]) {
      Managers.History.registerTotal(`fish-${ fishId }`, counts[fishId]);
    }
  }

  Managers.History.registerTotal('fish-caught', total);
}

function countSacisFound(content) {
  Variables.sacisFound = 0;

  if (!content.mods || !content.mods.sacis) {
    return;
  }

  for (const saciId in content.mods.sacis) {
    if (!saciId) {
      continue;
    }

    if (content.mods.sacis[saciId] === 'found') {
      Variables.sacisFound++;
    }
  }

  const newMaxFatigue = 100 + Math.floor(Variables.sacisFound / 20) * 10;
  if (Managers.Health.maxFatigue > newMaxFatigue) {
    const title = t("UPDATE NOTICE");
    const text = t("Your maximum fatigue was reduced because thanks to a bug you had found the same Saci multiple times. The total number of unique Sacis you've found is <sacisFound>.").replace('<sacisFound>', Variables.sacisFound);
    const notice = Managers.Text.replaceTextVariables(`<color:important>v0.6.1.14 - ${ title }</color><BR>${ text }`);

    $gameTemp.addUpdateNotice(notice);
  }

  Managers.Health.maxFatigue = newMaxFatigue;
}

function relocateInnSaciLog(content) {
  if (!content || !content.farmObjects || !content.farmObjects.farmObjects) {
    return;
  }

  const farmObjects = content.farmObjects.farmObjects;
  if (!farmObjects[27]) {
    return;
  }

  const townObjects = farmObjects[27];
  for (const farmObject of townObjects) {
    if (!farmObject) {
      continue;
    }

    if (farmObject.x == 48 && farmObject.y == 33) {
      farmObject.y = 34;
    }
  }
}

function clearLastFruitFlag(content) {
  if (!content || !content.farmObjects || !content.farmObjects.farmObjects) {
    return;
  }

  const farmObjects = content.farmObjects.farmObjects;
  if (!farmObjects) {
    return;
  }

  for (const mapId in farmObjects) {
    if (!mapId || !farmObjects[mapId] || !farmObjects[mapId].length) {
      continue;
    }

    for (const obj of farmObjects[mapId]) {
      if (!obj) {
        continue;
      }

      if (obj.lastFruit) {
        obj.lastFruit = false;
      }
    }
  }
}

function restoreBathroomAnimals() {
  if (!Managers.Creatures._creatures) {
    return;
  }

  const creatures = Managers.Creatures._creatures[72];
  if (creatures && creatures.length) {
    Managers.Creatures.moveAnimalsToHome(creatures);
  }
}

function replaceEventTrees() {
  const add = (mapId, x, y, modelName) => {
    if ($gameSystem.isMapInitialized(mapId)) {
      Managers.FarmObjects.createFarmObjectAt(mapId, x, y, modelName);
    }
  };

  add(Maps.FARM, 8, 0, 'small-tree');
}

function removeOldTrees() {
  Managers.FarmObjects.destroyEverythingOnPositionList(89, [
    {x: 5, y: 11},
    {x: 7, y: 8},
    {x: 7, y: 19},
    {x: 10, y: 16},
    {x: 10, y: 21},
    {x: 14, y: 14},
    {x: 18, y: 15},
    {x: 21, y: 12},
    {x: 24, y: 24},
    {x: 25, y: 4},
    {x: 26, y: 11},
  ]);
}

function changeAnimalTypes() {
  const oldCows = [];
  const newCows = ['cow'];
  const newGoats = ['goat'];
  const oldDucks = ['duck7', 'duck8'];
  const oldGoats = ['goat7', 'goat8'];

  for (let i = 9; i <= 24; i++) {
    oldCows.push(`cow${ i }`);
    oldGoats.push(`goat${ i }`);
  }
  for (let i = 2; i <= 8; i++) {
    newCows.push(`cow${ i }`);
    if (i <= 6) {
      newGoats.push(`goat${ i }`);
    }
  }

  const animals = Managers.Creatures.getAnimalList();
  for (const animal of animals) {
    if (oldCows.includes(animal.type)) {
      animal.type = newCows[Math.randomInt(newCows.length)];
      continue;
    }
    if (oldGoats.includes(animal.type)) {
      animal.type = newGoats[Math.randomInt(newGoats.length)];
      continue;
    }

    if (oldDucks.includes(animal.type)) {
      animal.type = 'duck';
    }
  }
}

function updateCreatures() {
  if (!Managers.Creatures._creatures) {
    return;
  }

  const allCreatureMaps = Managers.Creatures._creatures;
  for (const mapId in allCreatureMaps) {
    if (!mapId) continue;

    const creatureMap = allCreatureMaps[mapId];
    if (!creatureMap) continue;
    if (!creatureMap.length) continue;

    for (const creature of creatureMap) {
      if (!creature) continue;

      if (creature._type === 'dog15') {
        creature._type = 'dog7';
      }
    }
  }
}

function resetAllMaps() {
  $gameSystem.resetMap(2, true);
  $gameSystem.resetMap(5, true);
  $gameSystem.resetMap(6, true);
  $gameSystem.resetMap(7, true);
  $gameSystem.resetMap(8, true);
  $gameSystem.resetMap(10, true);
  $gameSystem.resetMap(11, true);
  $gameSystem.resetMap(12, true);
  $gameSystem.resetMap(12, true);
  $gameSystem.resetMap(15, true);
  $gameSystem.resetMap(16, true);
  $gameSystem.resetMap(17, true);
  $gameSystem.resetMap(18, true);
  $gameSystem.resetMap(21, true);
  $gameSystem.resetMap(22, true);
  $gameSystem.resetMap(23, true);
  $gameSystem.resetMap(24, true);
  $gameSystem.resetMap(25, true);
  $gameSystem.resetMap(26, true);
  $gameSystem.resetMap(27, true);
  $gameSystem.resetMap(28, true);
  $gameSystem.resetMap(30, true);
  $gameSystem.resetMap(32, true);
  $gameSystem.resetMap(34, true);
  $gameSystem.resetMap(35, true);
  $gameSystem.resetMap(36, true);
  $gameSystem.resetMap(37, true);
  $gameSystem.resetMap(39, true);
  $gameSystem.resetMap(40, true);
  $gameSystem.resetMap(41, true);
  $gameSystem.resetMap(42, true);
  $gameSystem.resetMap(43, true);
  $gameSystem.resetMap(44, true);
  $gameSystem.resetMap(46, true);
  $gameSystem.resetMap(47, true);
  $gameSystem.resetMap(48, true);
  $gameSystem.resetMap(49, true);
  $gameSystem.resetMap(50, true);
  $gameSystem.resetMap(51, true);
  $gameSystem.resetMap(53, true);
  $gameSystem.resetMap(55, true);
  $gameSystem.resetMap(56, true);
  $gameSystem.resetMap(58, true);
  $gameSystem.resetMap(61, true);
  $gameSystem.resetMap(62, true);
  $gameSystem.resetMap(64, true);
  $gameSystem.resetMap(65, true);
  $gameSystem.resetMap(69, true);
  $gameSystem.resetMap(71, true);
  $gameSystem.resetMap(73, true);
  $gameSystem.resetMap(74, true);
  $gameSystem.resetMap(75, true);
  $gameSystem.resetMap(76, true);
  $gameSystem.resetMap(77, true);
  $gameSystem.resetMap(78, true);
  $gameSystem.resetMap(79, true);
  $gameSystem.resetMap(80, true);
  $gameSystem.resetMap(81, true);
  $gameSystem.resetMap(83, true);
  $gameSystem.resetMap(90, true);
  $gameSystem.resetMap(93, true);
  $gameSystem.resetMap(94, true);
  $gameSystem.resetMap(98, true);
  $gameSystem.resetMap(99, true);
  $gameSystem.resetMap(100, true);
  $gameSystem.resetMap(103, true);
  $gameSystem.resetMap(105, true);
  $gameSystem.resetMap(108, true);
  $gameSystem.resetMap(109, true);
}

function convertAnimalFood() {
  Variables.feedCount = 0;
  let feedCount = 0;

  const key = [0, 0, 'A'];
  for (let mapId = 66000; mapId <= 66999; mapId++) {
    key[0] = mapId;

    for (let i = 15; i <= 28; i++) {
      key[1] = i;
      if ($gameSelfSwitches.value(key)) {
        $gameSelfSwitches.setValue(key, false);
        feedCount++;
      }
    }
  }

  if (feedCount > 0) {
    Managers.Items.storageContainer.gainItemId('chicken-feed', feedCount);
  }

  let hayCount = 0;
  for (let mapId = 9000; mapId <= 9999; mapId++) {
    key[0] = mapId;
    for (let i = 1; i <= 16; i++) {
      if ($gameSelfSwitches.value(key)) {
        $gameSelfSwitches.setValue(key, false);
        hayCount++;
      }
    }
  }

  if (hayCount > 0) {
    Managers.Items.storageContainer.gainItemId('hay', hayCount);
  }
}

function replaceBuildings() {
  // First, move every animal to the animal camp
  const creatures = Managers.Creatures._creatures;
  const campCreatures = [];
  const homeCreatures = [];
  const worldCreatures = [];
  const homeMapId = $gameSystem.currentHome();

  for (const mapId in creatures) {
    if (isNaN(mapId)) continue;

    const mapCreatures = creatures[mapId];
    if (!mapCreatures || !mapCreatures.length) {
      continue;
    }

    for (const creature of mapCreatures) {
      if (!creature) continue;

      const { _type } = creature;

      if (_type.startsWith('duck') || _type.startsWith('cat') || _type.startsWith('squirrel') || _type.startsWith('monkey') || _type.startsWith('bunny') || _type.startsWith('small-turtle') || _type.startsWith('dog')) {
        creature._homeMapId = Maps.WORLD;
        creature._homeX = 1;
        creature._homeY = 1;
        worldCreatures.push(creature);
      } else if (_type === 'shiba') {
        creature._homeMapId = homeMapId;
        creature._homeX = 17;
        creature._homeY = 5;
        homeCreatures.push(creature);
      } else {
        creature._homeMapId = Maps.ANIMAL_CAMP;
        creature._homeX = 1;
        creature._homeY = 1;

        campCreatures.push(creature);
      }

      creature._mapId = creature._homeMapId;
      creature._x = creature._homeX;
      creature._y = creature._homeY;
    }

    delete creatures[mapId];
  }

  creatures[Maps.ANIMAL_CAMP] = campCreatures;
  creatures[homeMapId] = homeCreatures;

  const objectsToRemove = [
    'barn',
    'coop',
    'cheese-maker',
    'mayo-maker',
    'hay-maker',
    'feed-maker',
    'seed-maker',
  ];

  // Then, remove every building/object and add them as items on the storage
  const farmObjects = Managers.FarmObjects._farmObjects;
  for (const mapId in farmObjects) {
    if (isNaN(mapId)) continue;

    const mapObjects = farmObjects[mapId];
    if (!mapObjects) continue;

    for (const obj of mapObjects) {
      if (!obj || !obj.modelName) continue;

      if (objectsToRemove.includes(obj.modelName)) {
        Managers.Items.storageContainer.gainItemId(obj.modelName);
        obj.clear();
      }
    }
  }

  Managers.FarmObjects.clearEmptyItems();

  // Flag every building as unused
  for (const barn of Managers.FarmObjects._barns) {
    if (barn) {
      barn.used = false;
    }
  }

  for (const coop of Managers.FarmObjects._coops) {
    if (coop) {
      coop.used = false;
    }
  }

  const title = t("UPDATE NOTICE");
  const text = t("Your barns, coops and machines were moved to the storage. Your animals were all moved to the vet. Place the buildings back on your farm then talk to Mia to retrieve your animals.");
  const notice = Managers.Text.replaceTextVariables(`<color:important>v0.6.2 - ${ title }</color><BR>${ text }`);

  $gameTemp.addUpdateNotice(notice);
}

Managers.Updates.runV06Updates = function(loadedVersion, content) {
  this.addMigration(0.6020, () => {
    addMeetEveryoneTask();
  });

  this.addMigration(0.6022, () => {
    changePlayerHousePositions(content);
    Switches.forceGoHome = true;
  });

  this.addMigration(0.6024, () => {
    migrateTalkStageVariables(content);
  });

  this.addMigration(0.6026, () => {
    clearReservedHouseSpace(content);
  });

  this.addMigration(0.6104, () => {
    Variables.bathCount = 0;
    fixCurupiraTask(content);
  });

  this.addMigration(0.6108, () => {
    countFishCaught();
  });

  this.addMigration(0.6114, () => {
    countSacisFound(content);
    relocateInnSaciLog(content);
  });

  this.addMigration(0.6116, () => {
    clearLastFruitFlag(content);
  });

  this.addMigration(0.6118, () => {
    restoreBathroomAnimals();
  });

  this.addMigration(0.6122, () => {
    replaceEventTrees();
  });

  this.addMigration(0.6126, () => {
    removeOldTrees();
  });

  this.addMigration(0.6127, () => {
    changeAnimalTypes();
  });

  this.addMigration(0.6128, () => {
    updateCreatures();
  });

  this.addMigration(0.6129, () => {
    resetAllMaps();
  });

  this.addMigration(0.6200, () => {
    convertAnimalFood();
    replaceBuildings();
    Switches.forceGoHome = true;
  });
};