require('game/managers/Updates');

function removeTeleporter() {
  if (Switches.hasRibbon) {
    Switches.hasRibbon = false;
    if (Managers.Tools.toolId == 'teleport') {
      Managers.Tools.toolId = undefined;
    }

    const title = t("UPDATE NOTICE");
    const text = t("The teleport skill has been removed. You'll need to find and complete a series of tasks to obtain it again.");
    const notice = Managers.Text.replaceTextVariables(`<color:important>v0.5 - ${ title }</color><BR>${ text }`);

    $gameTemp.addUpdateNotice(notice);
  }
}

function resetUnusedSwitch() {
  $gameSwitches.setValue(80, false);
}

function loadModCookingData(content) {
  if (!content.mods) return;

  if (content.mods.recipesLearnt) {
    Managers.Cooking.recipesLearnt = content.mods.recipesLearnt;
  }

  if (content.mods.kitchen) {
    // Managers.Cooking.kitchenContainer.setData(content.mods.kitchen);
  }
}

function loadInitialFlowers(content) {
  for (let y = 28; y <= 33; y++) {
    if (y <= 32) {
      for (let x = 4; x <= 6; x++) {
        Managers.FarmObjects.createFlowerObjectAt(4, x, y);
      }
    }

    if (y >= 30) {
      Managers.FarmObjects.createFlowerObjectAt(4, 7, y);
      Managers.FarmObjects.createFlowerObjectAt(4, 8, y);
    }
  }
}

function fixCropPoints(content) {
  const crops = [
    'pineapple',
    'cassava',
    'greenpepper',
    'sweet-potato',
    'spinach'
  ];

  const farmObjects = content.farmObjects.farmObjects;
  for (const mapId in farmObjects) {
    const mapObjects = farmObjects[mapId];
    if (!mapObjects) continue;

    for (const obj of mapObjects) {
      if (!obj) continue;

      if (!obj.modelName) continue;
      if (!obj.modelName.endsWith('-crop')) continue;

      const modelName = obj.modelName.replace('-crop', '');
      if (crops.indexOf(modelName) < 0) continue;

      if (obj.age > obj.points) {
        obj.points = obj.age;
        obj._spoiled = false;

        obj.updateStage();
      }
    }
  }
}

function decreaseExpPoints() {
  if (Managers.Player.sleepingExp) {
    Managers.Player.sleepingExp /= 50;
  }

  if (Managers.Player.walkingExp) {
    Managers.Player.walkingExp /= 500;
  }
}

function replaceBoulders(content) {
  const farmObjects = content.farmObjects.farmObjects;
  for (const mapId in farmObjects) {
    const mapObjects = farmObjects[mapId];
    if (!mapObjects) continue;

    for (const obj of mapObjects) {
      if (!obj) continue;

      if (!obj.modelName) continue;
      if (obj.modelName != 'boulder') continue;

      obj.modelName = 'rock-4';

      if (mapId == 2) {
        if (obj.x == 1 && obj.y == 67) {
          obj.modelName = 'rock-3';
        } else if (obj.x == 56 && obj.y == 47) {
          obj.modelName = 'rock-3';
        } else if (obj.x == 8 && obj.y == 81) {
          obj.modelName = 'rock-3';
        }
      } else if (mapId == 37) {
        obj.modelName = 'rock-3';
      }
    }
  }
}

function addPendingSprinklers() {
  if (Switches.devinMakingAnotherSprinkler) {
    Managers.Items.mailboxContainer.gainItemId('sprinkler');
    Switches.devinMakingAnotherSprinkler = false;
  }
}

function splitFarmingExp() {
  const exp = Managers.Player.farmingExp;

  if (exp > 0) {
    Managers.Player.waterExp = exp / 2;
    Managers.Player.hoeExp = exp / 2;
    Managers.Player.sickleExp = exp / 4;
  }
}

function addToolExperienceNotice() {
  let anyDowngrade = false;
  if (Switches.hasGoldenHoe && Managers.Player.hoeExp < 1500) {
    anyDowngrade = true;
  } else if (Switches.hasSilverHoe && Managers.Player.hoeExp < 750) {
    anyDowngrade = true;
  } else if (Switches.hasCopperHoe && Managers.Player.hoeExp < 250) {
    anyDowngrade = true;
  } else if (Switches.hasGoldenHammer && Managers.Player.hammerExp < 1500) {
    anyDowngrade = true;
  } else if (Switches.hasSilverHammer && Managers.Player.hammerExp < 750) {
    anyDowngrade = true;
  } else if (Switches.hasCopperHammer && Managers.Player.hammerExp < 250) {
    anyDowngrade = true;
  } else if (Switches.hasGoldenSickle && Managers.Player.sickleExp < 1500) {
    anyDowngrade = true;
  } else if (Switches.hasSilverSickle && Managers.Player.sickleExp < 750) {
    anyDowngrade = true;
  } else if (Switches.hasCopperSickle && Managers.Player.sickleExp < 250) {
    anyDowngrade = true;
  } else if (Switches.hasGoldenAxe && Managers.Player.woodcuttingExp < 1500) {
    anyDowngrade = true;
  } else if (Switches.hasSilverAxe && Managers.Player.woodcuttingExp < 750) {
    anyDowngrade = true;
  } else if (Switches.hasCopperAxe && Managers.Player.woodcuttingExp < 250) {
    anyDowngrade = true;
  } else if (Switches.hasGreenWateringCan && Managers.Player.waterExp < 3000) {
    anyDowngrade = true;
  } else if (Switches.hasRedWateringCan && Managers.Player.waterExp < 2000) {
    anyDowngrade = true;
  } else if (Switches.hasSilverWateringCan && Managers.Player.waterExp < 1000) {
    anyDowngrade = true;
  }

  if (anyDowngrade) {
    const title = t("UPDATE NOTICE");
    const text = t("Some of your tools have been downgraded due to the new experience system. They'll be upgraded automatically once you get the required experience.");
    const notice = Managers.Text.replaceTextVariables(`<color:important>v0.5.1 - ${ title }</color><BR>${ text }`);

    $gameTemp.addUpdateNotice(notice);
  }
}

function restoreBankMoney(content) {
  if (content.bank && content.bank.balance) {
    Managers.Items.gainGold(Math.round(content.bank.balance), true, false);
  }
}

function migrateMountain(content) {
  const coops = content.farmObjects.coops;
  for (const coop of coops) {
    if (!coop || coop.mapId != 2) continue;

    if (coop.y <= 18) {
      coop.mapId = 28;
    } else {
      coop.y -= 19;
    }
  }

  const barns = content.farmObjects.barns;
  for (const barn of barns) {
    if (!barn || barn.mapId != 2) continue;

    if (barn.y <= 18) {
      barn.mapId = 28;
    } else {
      barn.y -= 19;
    }
  }

  const mountainCreatures = Managers.Creatures._creatures[2];
  if (mountainCreatures) {
    for (const creature of mountainCreatures) {
      if (creature.y <= 18) {
        Managers.Creatures.moveAnimal(creature, 28, creature.x, creature.y, creature.d);
        creature.mapId = 28;
      } else {
        creature.y -= 19;
      }
    }
  }

  const allCreatureMaps = Managers.Creatures._creatures;
  for (const mapId in allCreatureMaps) {
    if (!mapId) continue;

    const creatureMap = allCreatureMaps[mapId];
    if (!creatureMap) continue;
    if (!creatureMap.length) continue;

    for (const creature of creatureMap) {
      if (!creature) continue;
      if (creature._homeMapId !== 2) continue;

      if (creature._homeY <= 18) {
        creature._homeMapId = 28;
      } else {
        creature._homeY -= 19;
      }
    }
  }

  var pomData = $gameSystem.getExtraData('pom');

  if (pomData) {
    if (pomData.mapId == 2) {
      pomData.x = 6;
      pomData.y = 32;
    }

    $gameSystem.setExtraData('pom', pomData);
  }
}

function migrateDevinSwitches() {
  Switches.playedDevinHeartEvent0 = Boolean(Switches.playedDevinEventGifts1);
  Switches.playedDevinHeartEvent0B = Boolean(Switches.playedDevinEventGifts2);
  Switches.playedDevinHeartEvent0C = Boolean(Switches.playedDevinEventGifts3);
  Switches.playedDevinHeartEvent0D = Boolean(Switches.playedDevinEventGifts4);

  delete Switches.playedDevinEventGifts1;
  delete Switches.playedDevinEventGifts2;
  delete Switches.playedDevinEventGifts3;
  delete Switches.playedDevinEventGifts4;
}

Managers.Updates.runV05Updates = function(loadedVersion, content) {
  this.addMigration(0.5002, () => {
    removeTeleporter();
    resetUnusedSwitch();
  });

  this.addMigration(0.5006, () => {
    loadModCookingData(content);
  });

  this.addMigration(0.5007, () => {
    loadInitialFlowers(content);
  });

  this.addMigration(0.5008, () => {
    fixCropPoints(content);
  });

  this.addMigration(0.5009, () => {
    decreaseExpPoints();
  });

  this.addMigration(0.5102, () => {
    replaceBoulders(content);
    Switches.foundSecondCart = false;
  });

  this.addMigration(0.5103, () => {
    addPendingSprinklers();
  });

  this.addMigration(0.5106, () => {
    content.farmObjects.farmObjects[34] = [];
  });

  this.addMigration(0.5107, () => {
    splitFarmingExp();
  });

  this.addMigration(0.5108, () => {
    addToolExperienceNotice();
  });

  this.addMigration(0.5113, () => {
    restoreBankMoney(content);
  });

  this.addMigration(0.5200, () => {
    Switches.amandaToldAboutFlowerFestival = Managers.Time.year > 1 || Managers.Time.yearDay > Festivals.FLOWER;
    Variables.flowerFestivalWins = 0;
  });

  this.addMigration(0.5203, () => {
    $gameSystem.resetMap(Maps.MAZE);
  });

  this.addMigration(0.5209, () => {
    migrateMountain(content);
  });

  this.addMigration(0.5210, () => {
    migrateDevinSwitches();
  });
};