require('game/managers/Updates');

(function(){
  function convertFarmObjectTypeToModel(content) {
    const farmObjects = content.farmObjects.farmObjects;
    const conversionTable = {
      'woodtree': 'regular-tree',
      'woodtree2': 'regular-tree-2',
      'woodtree3': 'regular-tree-3',
      'woodtree4': 'regular-tree-4',
      'woodtree5': 'regular-tree-5',
      'woodtree6': 'regular-tree-6',
      'woodtree-small': 'small-tree',
      'woodtree-small2': 'small-tree-2',
      'woodtree-small3': 'small-tree-3',
      'woodtree-small4': 'small-tree-4',
      'woodtree-small5': 'small-tree-5',
      'woodtree-small6': 'small-tree-6',
      'woodtree-medium': 'medium-tree',
      'woodtree-medium2': 'medium-tree-2',
      'woodtree-medium3': 'medium-tree-3',
      'woodtree-medium4': 'medium-tree-4',
      'woodtree-medium5': 'medium-tree-5',
      'woodtree-medium6': 'medium-tree-6',
      'gianttree': 'giant-tree',

      'apple': 'apple-crop',
      'orange': 'orange-crop',
      'peach': 'peach-crop',
      'blackberry': 'blackberry-crop',
      'coconut': 'coconut-crop',
      'raspberry': 'raspberry-crop',

      'beets': 'beets-crop',
      'bellpepper': 'bellpepper-crop',
      'broccoli': 'broccoli-crop',
      'carrot': 'carrot-crop',
      'eggplant': 'eggplant-crop',
      'greenpepper': 'greenpepper-crop',
      'peanut': 'peanut-crop',
      'pumpkin': 'pumpkin-crop',
      'radish': 'radish-crop',
      'rose': 'rose-crop',
      'spinach': 'spinach-crop',
      'sweet-potato': 'sweet-potato-crop',
      'daisy': 'daisy-crop',
      'mushroom': 'mushroom-crop',
      'sugarcane': 'sugarcane-crop',
      'wheat': 'wheat-crop',
      'cabbage': 'cabbage-crop',
      'cucumber': 'cucumber-crop',
      'jasmine': 'jasmine-crop',
      'pink-daisy': 'pink-daisy-crop',
      'potato': 'potato-crop',
      'strawberry': 'strawberry-crop',
      'turnip': 'turnip-crop',
      'cassava': 'cassava-crop',
      'chillipepper': 'chillipepper-crop',
      'corn': 'corn-crop',
      'grape': 'grape-crop',
      'onion': 'onion-crop',
      'pineapple': 'pineapple-crop',
      'sunflower': 'sunflower-crop',
      'tomato': 'tomato-crop',
      'watermelon': 'watermelon-crop',
      'yellow-daisy': 'yellow-daisy-crop',
      'cauliflower': 'cauliflower-crop',
      'leek': 'leek-crop',
      'lettuce': 'lettuce-crop',
      'white-rose': 'white-rose-crop',

      'stump': 'stump',
      'weed': 'weed',
      'small-weed': 'small-weed',
      'stone': 'stone',
      'boulder': 'boulder',
      'treeLog': 'treeLog',

      'coop': 'coop',
      'barn': 'barn',
      'gate': 'gate',
      'sprinkler': 'sprinkler'
    };

    for (const mapId in farmObjects) {
      const mapObjects = farmObjects[mapId];
      if (!mapObjects) continue;

      for (const obj of mapObjects) {
        if (!obj) continue;

        if (obj.itemName) {
          continue;
        }

        if (obj.isFence || obj._isFence) {
          obj.modelName = 'fence';
          delete obj.isFence;
          delete obj._isFence;
          continue;
        }

        if (obj.isButton || obj._isButton) {
          obj.modelName = 'button';
          delete obj.isButton;
          delete obj._isButton;
          continue;
        }

        if (obj._isStone) {
          obj.modelName = 'stone';
          delete obj._isStone;
          continue;
        }

        if (obj._isWeed || obj._isWeed2) {
          obj.modelName = 'weed';
          delete obj._isWeed;
          delete obj._isWeed2;
          continue;
        }

        if (obj._isLog) {
          obj.modelName = 'log';
          delete obj._isLog;
          continue;
        }

        if (obj._isStump) {
          obj.modelName = 'stump';
          delete obj._isStump;
          continue;
        }

        if (obj._isGrass) {
          obj.clear();
          continue;
        }

        const oldType = obj._cropName || obj._type || obj.modelName;

        if (oldType) {
          const modelName = conversionTable[oldType];
          if (modelName) {
            if (modelName == 'sprinkler') {
              console.log(obj);
            }
            obj.modelName = modelName;
          } else {
            console.log(...log('Unknown type: ' + oldType));
          }
        } else {
          if (!obj._tilled && !obj._rockType) {
            console.log(...log('Unknown object:', obj));
          }
        }
      }
    }
  }

  function fixPomPosition() {
    const pom = $gameSystem.getExtraData('pom');
    if (!pom) return;
    if (pom.mapId == 40) {
      pom.mapId = 2;
      pom.x = 5;
      pom.y = 48;

      $gameSystem.setExtraData('pom', pom);
    }
  }

  function renameCinth(content) {
    if (!content.relationship) {
      return;
    }

    const data = content.relationship;

    if (data.villagersFriendships) {
      const npcData = data.villagersFriendships;
      if (npcData.Cinth) {
        npcData.Cindy = npcData.Cinth;
        delete npcData.Cinth;
      }

      for (let name in npcData) {
        if (npcData[name] && npcData[name].Cinth) {
          npcData[name].Cindy = npcData[name].Cinth;
          delete npcData[name].Cinth;
        }
      }
    }

    if (data.friendship) {
      if (data.friendship.Cinth) {
        data.friendship.Cindy = data.friendship.Cinth;
        delete data.friendship.Cinth;
      }
    }

    if (data.giftDates) {
      if (data.giftDates.Cinth) {
        data.giftDates.Cindy = data.giftDates.Cinth;
        delete data.giftDates.Cinth;
      }
    }

    if (data.gifts) {
      if (data.gifts.Cinth) {
        data.gifts.Cindy = data.gifts.Cinth;
        delete data.gifts.Cinth;
      }
    }

    if (data.interestType) {
      if (data.interestType.Cinth) {
        data.interestType.Cindy = data.interestType.Cinth;
        delete data.interestType.Cinth;
      }
    }
  }

  Managers.Updates.runV04Updates = function(loadedVersion, content) {
    this.addMigration(0.4042, () => {
      fixPomPosition();
    });

    this.addMigration(0.4042, () => {
      convertFarmObjectTypeToModel(content);
    });

    this.addMigration(0.4044, () => {
      // removeTeleporter();
      renameCinth(content);
    });
  };
})();