require('game/managers/Updates');

(function(){
  function clearShadowSwitches() {
    for (var i = 209; i <= 213; i++) {
      $gameSwitches.setValue(209, false);
    }
  }

  function addSprinklers() {
    if (Managers.Mailbox.receivedMail.indexOf('mailbox_another_sprinkler_finished') >= 0) {
      Managers.Items.mailboxContainer.gainItemId('sprinkler');
    }
  }

  function removeOldBuildings() {
    // If the player has not yet seen Raphael's tutorial event, remove any coop he has
    if (!Switches.playedRaphaelTutorial) {
      var farmObjects = Managers.FarmObjects.getMapFarmObjects(36);
      if (farmObjects && farmObjects.length) {
        farmObjects.forEach(function(obj){
          if (!obj) return;

          if (obj.type == Constants.FarmObjectState.COOP) {
            obj.type = undefined;
          }
        });

        Managers.FarmObjects.clearEmptyItems();
        Managers.FarmObjects.updateProtectedTiles(36);
      }
    }
  }

  function replaceGates() {
    for (var mapId in Managers.FarmObjects._farmObjects) {
      if (!Managers.FarmObjects._farmObjects.hasOwnProperty(mapId)) continue;

      var mapObjects = Managers.FarmObjects._farmObjects[mapId];
      for (var i = 0; i < mapObjects.length; i++) {
        var object = mapObjects[i];
        if (!object) continue;
        if (object.type == 'gate') {
          object.type = undefined;
          object.isFence = true;
        }
      }
    }
  }

  function createInitialBoulders() {
  }

  function replaceRobertoWithMartin() {
    var idx = Managers.Relationship.data.villagersMetToday.indexOf('Roberto');
    if (idx >= 0) {
      Managers.Relationship.data.villagersMetToday[idx] = 'Martin';
    }

    idx = Managers.Relationship.data.knownVillagers.indexOf('Roberto');
    if (idx >= 0) {
      Managers.Relationship.data.knownVillagers[idx] = 'Martin';
    }

    if (Managers.Relationship.data.friendship.Roberto) {
      Managers.Relationship.data.friendship.Martin = Managers.Relationship.data.friendship.Roberto;
      delete Managers.Relationship.data.friendship.Roberto;
    }

    if (Managers.Relationship.data.gifts.Roberto) {
      Managers.Relationship.data.gifts.Martin = Managers.Relationship.data.gifts.Roberto;
      delete Managers.Relationship.data.gifts.Roberto;
    }

    if (Managers.Relationship.data.giftDates.Roberto) {
      Managers.Relationship.data.giftDates.Martin = Managers.Relationship.data.giftDates.Roberto;
      delete Managers.Relationship.data.giftDates.Roberto;
    }

    idx = Managers.Mailbox.receivedMail.indexOf('mailbox_roberto_reward_letter');
    if (idx >= 0) {
      Managers.Mailbox.receivedMail[idx] = 'mailbox_martin_reward_letter';
    }
  }

  function removeOldMinersGuildQuests() {
    if (Managers.Tasks.taskData['joining-miners-guild-1']) {
      if (Managers.Tasks.getTaskStatus('joining-miners-guild-1') == TaskStatus.COMPLETED) {
        Managers.Relationship.decreaseFriendship('Martin', 100);
      }

      delete Managers.Tasks.taskData['joining-miners-guild-1'];
    }

    if (Managers.Tasks.taskData['joining-miners-guild-2']) {
      if (Managers.Tasks.getTaskStatus('joining-miners-guild-2') == TaskStatus.COMPLETED) {
        Managers.Relationship.decreaseFriendship('Martin', 120);
      }

      delete Managers.Tasks.taskData['joining-miners-guild-2'];
    }

    if (Managers.Tasks.taskData['joining-miners-guild-3']) {
      if (Managers.Tasks.getTaskStatus('joining-miners-guild-3') == TaskStatus.COMPLETED) {
        Managers.Relationship.decreaseFriendship('Martin', 150);
      }

      delete Managers.Tasks.taskData['joining-miners-guild-3'];
    }

    if (Managers.Tasks.taskData['joining-miners-guild-4']) {
      if (Managers.Tasks.getTaskStatus('joining-miners-guild-4') == TaskStatus.COMPLETED) {
        Managers.Relationship.decreaseFriendship('Martin', 200);
      }

      delete Managers.Tasks.taskData['joining-miners-guild-4'];
    }
  }

  function registerShippedItemsValue() {
    for (var key in Managers.History._totalData) {
      if (!key.startsWith('ship-')) continue;

      var itemId = key.replace('ship-', '');
      var itemData = Managers.Items.getItemData(itemId);
      if (!itemData) continue;

      var itemAmount = Managers.History.getShippedItems(itemId) || 0;
      var itemSellPrice = itemData.sellPrice || 0;
      var totalGold = itemSellPrice * itemAmount;

      Managers.History.registerTotal('value-ship-' + itemId, totalGold);
    }
  }

  function updateCharacterColors() {
    switch (Managers.Player._hairType) {
      case 1:
        if (Managers.Player.isMale()) {
          Managers.Player._hairType = 14;
        } else {
          Managers.Player._hairType = 12;
        }
        break;
      case 2:
        Managers.Player._hairType = 3;
        break;
      case 3:
        Managers.Player._hairType = 9;
        break;
      case 4:
        Managers.Player._hairType = 7;
        break;
      case 5:
        if (Managers.Player.isMale()) {
          Managers.Player._hairType = 12;
        } else {
          Managers.Player._hairType = 14;
        }
        break;
      case 6:
        Managers.Player._hairType = 11;
        break;
      case 7:
        Managers.Player._hairType = 2;
        break;
      case 8:
        Managers.Player._hairType = 13;
        break;
      case 9:
        Managers.Player._hairType = 8;
        break;
      case 10:
        Managers.Player._hairType = 5;
        break;
      case 11:
        Managers.Player._hairType = 4;
        break;
      case 12:
        Managers.Player._hairType = 10;
        break;
      case 13:
        Managers.Player._hairType = 1;
        break;
    }
  }

  function clearWildMaps() {
    $gameSystem.resetMap(31, true);
    $gameSystem.resetMap(96, true);
  }

  function moveStuffToNewFarm() {
    $gameSystem.resetMap(4, true);
    var farmObjects = Managers.FarmObjects._farmObjects[36];
    if (farmObjects) {
      var newFarmObjects = [];

      for (var i = 0; i < farmObjects.length; i++) {
        var obj = farmObjects[i];
        if (!obj) continue;

        obj.mapId = 4;
        obj.x += 18;
        obj.y += 11;
        newFarmObjects.push(obj);
      }

      Managers.FarmObjects._farmObjects[4] = newFarmObjects;
      Managers.FarmObjects._farmObjects[36] = [];
    }

    var farmCreatures = Managers.Creatures._creatures[36];
    if (farmCreatures) {
      for (var j = 0; j < farmCreatures.length; j++) {

        var creature = farmCreatures[j];
        if (!creature) continue;

        creature.mapId = 4;
        creature.x += 18;
        creature.y += 11;
      }

      Managers.Creatures._creatures[4] = farmCreatures;
      Managers.Creatures._creatures[36] = [];
    }

    for (var b = 0; b < Managers.FarmObjects._barns.length; b++) {
      var barnData = Managers.FarmObjects._barns[b];
      if (!barnData) continue;

      if (barnData.mapId == 36) {
        barnData.mapId = 4;
        barnData.x += 18;
        barnData.y += 11;
      }
    }

    for (var c = 0; c < Managers.FarmObjects._coops.length; c++) {
      var coopData = Managers.FarmObjects._coops[c];
      if (!coopData) continue;

      if (coopData.mapId == 36) {
        coopData.mapId = 4;
        coopData.x += 18;
        coopData.y += 11;
      }
    }
  }

  function movePlayerToHomeMap() {
    $gamePlayer.reserveTransfer($gameSystem.currentHome(), 15, 10, Direction.UP, 0, false, false);
  }

  function clearOldSwitches() {
    $gameSwitches.setValue(75, false);
    $gameSwitches.setValue(180, false);
  }

  function adjustBrokenAxeSelfSwitch() {
    var value = $gameSelfSwitches.value([46, 1, 'A']);
    $gameSelfSwitches.setValue([15, 3, 'A'], value);
  }

  function addInitialDog() {
    //If the player doesn't have the dog yet, add it
    var dog = Managers.Creatures.getCreatureById('dog');
    if (!dog) {
      Managers.Creatures.createDog();
    }
  }

  function moveFallCrops() {
    var objs = Managers.FarmObjects._farmObjects[97];
    if (!objs) return;
    var newObjs = Managers.FarmObjects._farmObjects[96] || [];

    for (var i = 0; i < objs.length; i++) {
      var obj = objs[i];
      if (!obj) continue;

      if (obj.x < 3 || obj.x > 21) continue;
      if (obj.y < 4 || obj.y > 17) continue;

      if (obj.mapId != 96) {
        obj.mapId = 96;
        obj.x += 32;
      }

      newObjs.push(obj);
    }

    Managers.FarmObjects._farmObjects[96] = newObjs;
  }

  function moveSpringCrops() {
    var objs = Managers.FarmObjects._farmObjects[92];
    if (!objs) return;

    var newObjs = Managers.FarmObjects._farmObjects[31] || [];

    for (var i = 0; i < objs.length; i++) {
      var obj = objs[i];
      if (!obj) continue;

      if (obj.x < 14 || obj.x > 24) continue;
      if (obj.y < 10 || obj.y > 14) continue;

      if (obj.mapId != 31) {
        obj.mapId = 31;
        obj.x -= 6;
        obj.y -= 2;
      }

      newObjs.push(obj);
    }

    Managers.FarmObjects._farmObjects[31] = newObjs;
  }

  function fixSummerCrops() {
    var objs = Managers.FarmObjects._farmObjects[89];
    if (!objs) return;

    for (var i = 0; i < objs.length; i++) {
      var obj = objs[i];
      if (!obj) continue;

      if (obj.y < 24) continue;

      obj.clear();
    }

    $gameSystem._initializedMaps[89] = false;
  }

  function removeOldTasks() {
    delete Managers.Tasks.taskData['eustaces-bridge'];
  }

  const restoreWildAnimals = function() {
    function restorePosition(animalId, mapId, x, y, d) {
      if (!animalId) return;

      var creature = Managers.Creatures.getCreatureById(animalId);
      if (!creature) return;

      Managers.Creatures.moveAnimal(creature, mapId, x, y, d);
      creature.homeMapId = mapId;
      creature.homeX = x;
      creature.homeY = y;
    }

    restorePosition(Variables.dog1Id, Maps.ORANGE_TOWN, 37, 74, Direction.DOWN);
    restorePosition(Variables.turtle1Id, Maps.ORANGE_TOWN, 73, 64, Direction.LEFT);
    restorePosition(Variables.turtle2Id, Maps.ORANGE_TOWN, 68, 43, Direction.DOWN);
    restorePosition(Variables.turtle3Id, Maps.ORANGE_TOWN, 67, 51, Direction.DOWN);
    restorePosition(Variables.cat1Id, Maps.ORANGE_TOWN, 51, 21, Direction.DOWN);
    restorePosition(Variables.cat2Id, Maps.MOUNTAIN, 27, 46, Direction.DOWN);
    restorePosition(Variables.cat3Id, Maps.MOUNTAIN, 13, 48, Direction.DOWN);
    restorePosition(Variables.cat4Id, Maps.ORANGE_TOWN, 12, 22, Direction.DOWN);
    restorePosition(Variables.dog2Id, Maps.ORANGE_TOWN, 29, 11, Direction.LEFT);
    restorePosition(Variables.squirrel1Id, Maps.FOREST, 35, 63, Direction.LEFT);

    restorePosition(Variables.monkey1Id, Maps.FOREST, 58, 60, Direction.LEFT);
    restorePosition(Variables.monkey2Id, Maps.SUMMER_AREA, 20, 15, Direction.LEFT);
    restorePosition(Variables.monkey3Id, Maps.WINTER_FARM, 14, 18, Direction.RIGHT);

    restorePosition(Variables.bunny1Id, Maps.FOREST, 23, 65, Direction.LEFT);

    restorePosition('dog', Maps.FARM, 35, 9, Direction.DOWN);
  };

  function moveOldFarmCenterStuff() {
    $gameSystem.resetMap(33, true);
    var farmObjects = Managers.FarmObjects._farmObjects[52];
    if (farmObjects) {
      var newFarmObjects = [];

      for (var i = 0; i < farmObjects.length; i++) {
        var obj = farmObjects[i];
        if (!obj) continue;

        obj.mapId = 33;
        newFarmObjects.push(obj);
      }

      Managers.FarmObjects._farmObjects[33] = newFarmObjects;
      Managers.FarmObjects._farmObjects[52] = [];
    }

    var farmCreatures = Managers.Creatures._creatures[52];
    if (farmCreatures) {
      for (var j = 0; j < farmCreatures.length; j++) {

        var creature = farmCreatures[j];
        if (!creature) continue;

        creature.mapId = 33;
      }

      Managers.Creatures._creatures[33] = farmCreatures;
      Managers.Creatures._creatures[52] = [];
    }

    for (var b = 0; b < Managers.FarmObjects._barns.length; b++) {
      var barnData = Managers.FarmObjects._barns[b];
      if (!barnData) continue;

      if (barnData.mapId == 52) {
        barnData.mapId = 33;
      }
    }

    for (var c = 0; c < Managers.FarmObjects._coops.length; c++) {
      var coopData = Managers.FarmObjects._coops[c];
      if (!coopData) continue;

      if (coopData.mapId == 52) {
        coopData.mapId = 33;
      }
    }
  }

  Managers.Updates.runV03Updates = function(loadedVersion, content) {
    this.addMigration(0.3004, () => {
      clearShadowSwitches(content);
      addSprinklers(content);
    });

    this.addMigration(0.3005, () => {
      if (content.recipesLearnt) {
        Managers.Cooking.recipesLearnt = content.recipesLearnt;
      }
      if (content.kitchen !== undefined) {
        // Managers.Cooking.kitchenContainer.setData(content.kitchen);
      }
    });

    this.addMigration(0.3006, () => {
      removeOldBuildings(content);
      replaceGates(content);
      createInitialBoulders(content);
    });

    this.addMigration(0.3007, () => {
      replaceRobertoWithMartin(content);
    });

    this.addMigration(0.3008, () => {
      removeOldMinersGuildQuests(content);
      registerShippedItemsValue(content);
    });

    this.addMigration(0.3104, () => {
      updateCharacterColors(content);
    });

    this.addMigration(0.3300, () => {
      clearWildMaps(content);
      moveStuffToNewFarm(content);
      movePlayerToHomeMap(content);
      clearOldSwitches(content);
      adjustBrokenAxeSelfSwitch(content);
      addInitialDog(content);
      fixSummerCrops(content);
      removeOldTasks(content);
      moveFallCrops(content);
      moveSpringCrops(content);
    });

    this.addMigration(0.3301, () => {
      restoreWildAnimals(content);
    });

    this.addMigration(0.3304, () => {
      moveOldFarmCenterStuff(content);
    });

    this.addMigration(0.4, () => {
      $gameSystem.resetMap(2, true);
      restoreWildAnimals();

      if (typeof Variables.dogName != 'string') {
        var dog = Managers.Creatures.getCreatureById('dog');
        Variables.dogName = dog.creatureName;
      }

      if (typeof Variables.farmName != 'string') {
        Variables.farmName = t('Orange');
      }
    });

    this.addMigration(0.4001, () => {
      //The import script was not working properly
      if (loadedVersion > 0.3300) {
        moveFallCrops(content);
        moveSpringCrops(content);
      }
    });
  };
})();
