require('game/managers/Updates');

Managers.Updates.runV02Updates = function(loadedVersion, content) {
  this.addMigration(0.201, () => {
    this.resetSouthEastFarm();
  });

  this.addMigration(0.207, () => {
    this.removeVillagerFarms(content);
    Managers.Relationship.markCharacterAsKnown('Roberto');
    this.removeStonesFromMineLevel6(content);
  });

  this.addMigration(0.213, () => {
    this.removeOffsetFromObjects(content);
  });

  this.addMigration(0.216, () => {
    Switches.movedCaveBarrel = Switches.hasIronSickle;
  });

  this.addMigration(0.231, () => {
    this.moveContentFromOldHouseToNew(content);
  });

  this.addMigration(0.235, () => {
    this.convertSpriteNameToFemale(content);
  });

  this.addMigration(0.244, () => {
    this.removeOldIslandTrees(content);
  });

  this.addMigration(0.262, () => {
    this.assignAnimalIds(content);
    this.addNewWildAnimals(content);
    this.replaceCherryBushes(content);
  });

  this.addMigration(0.266, () => {
    this.switchBerries(content);
  });

  this.addMigration(0.272, () => {
    this.addMissingRooster(content);
  });

  this.addMigration(0.273, () => {
    this.registerCutsceneEvents(content);
  });

  this.addMigration(0.282, () => {
    this.fixInvalidItemId(content);
  });

  this.addMigration(0.283, () => {
    this.transferActivatedAchievements(content);
  });

  this.addMigration(0.284, () => {
    this.removeRibbonItem(content);
  });

  this.addMigration(0.288, () => {
    this.removeMiaTree(content);
  });

  this.addMigration(0.2905, () => {
    Switches.timeHudEnabled = true;
    Switches.toolHudEnabled = true;
  });

  this.addMigration(0.2910, () => {
    this.pickCurrentItem(content);
  });

  this.addMigration(0.2913, () => {
    this.removeOldTasks(content);
    this.clearTaskVariables(content);
  });

  this.addMigration(loadedVersion >= 0.2910 && 0.2914, () => {
    this.removeHoldingAnimal(content);
  });

  this.addMigration(0.2914, () => {
    this.addMissingPotatoSeeds(content);
  }, true);

  this.addMigration(0.2916, () => {
    this.addGhostItems(content);
  });

  this.addMigration(0.2917, () => {
    this.replaceSingleWheatItems(content);
  });
};

Managers.Updates.resetSouthEastFarm = function() {
  $gameSystem.resetMap(38);
};

Managers.Updates.removeVillagerFarms = function(content) {
  var farmObjects = content.farmObjects.farmObjects;

  const west = farmObjects[30];
  if (!west) return;

  function removeRectangle(list, x1, x2, y1, y2) {
    if (!list) return;

    for (var i = 0; i < list.length; i++) {
      if (!list[i]) continue;

      for (var x = x1; x <= x2; x++) {
        if (list[i].x != x) continue;

        for (var y = y1; y <= y2; y++) {
          if (list[i].y != y) continue;

          list[i]._cropName = '';
          list[i]._tilled = false;
        }
      }
    }
  }

  // Devin
  removeRectangle(west, 15, 16, 2, 3);
  // Nathalia
  removeRectangle(west, 23, 24, 2, 5);
  // Mia
  removeRectangle(west, 22, 25, 24, 24);
  // Benjamin
  removeRectangle(west, 4, 14, 17, 27);

  // Benjamin trees
  removeRectangle(west, 5, 13, 14, 14);
};

Managers.Updates.removeStonesFromMineLevel6 = function(content) {
  var farmObjects = content.farmObjects.farmObjects;
  var mine = farmObjects[55];

  if (!mine) return;

  for (var i = 0; i < mine.length; i++) {
    var obj = mine[i];

    if (!obj) continue;

    if (obj._cropName == FarmObjectState.STONE) {
      obj._cropName = '';
    }
  }
};

Managers.Updates.removeOffsetFromObjects = function(content) {
  var farmObjects = content.farmObjects.farmObjects;

  for (var mapId in farmObjects) {
    if (isNaN(mapId)) continue;
    var objects = farmObjects[mapId];

    for (var i = 0; i < objects.length; i++) {
      var obj = objects[i];

      if (!obj) continue;

      if (obj.offsetX) obj.offsetX = 0;
      if (obj.offsetY) obj.offsetY = 0;
    }
  }
};

Managers.Updates.moveContentFromOldHouseToNew = function() {
  if (!Switches.expandedHouse) return;

  Managers.Creatures.moveMapCreatures(Maps.HOME, Maps.HOME_2);
  Managers.FarmObjects.moveMapContent(Maps.HOME, Maps.HOME_2);

};

Managers.Updates.convertSpriteNameToFemale = function() {
  // This was the first version where the sprite was detached from gender
  if (Managers.Player._gender == 'female') {
    Managers.Player._sprite = 'heroine';
  }
};

Managers.Updates.removeOldIslandTrees = function() {
};

Managers.Updates.assignAnimalIds = function() {
  for (var mapId in Managers.Creatures._creatures) {
    if (!Managers.Creatures._creatures.hasOwnProperty(mapId)) continue;

    var mapCreatures = Managers.Creatures._creatures[mapId];
    for (var i = 0; i < mapCreatures.length; i++) {
      var creature = mapCreatures[i];
      if (!creature) continue;

      switch(creature.type) {
        case 'monkey' :
          Variables.monkey1Id = creature.id;
          break;
        case 'bunny' :
          Variables.bunny1Id = creature.id;
          break;
        case 'dog8' :
          Variables.dog1Id = creature.id;
          break;
        case 'small-turtle' :
          Variables.turtle1Id = creature.id;
          break;
        case 'small-turtle7' :
          Variables.turtle2Id = creature.id;
          break;
        case 'small-turtle8' :
          Variables.turtle3Id = creature.id;
          break;
        case 'cat' :
          Variables.cat1Id = creature.id;
          break;
        case 'cat4' :
          Variables.cat2Id = creature.id;
          break;
        case 'cat5' :
          Variables.cat3Id = creature.id;
          break;
        case 'cat6' :
          Variables.cat4Id = creature.id;
          break;
        case 'dog15' :
          Variables.dog2Id = creature.id;
          break;
        case 'squirrel' :
          Variables.squirrel1Id = creature.id;
          break;
      }
    }
  }
};

Managers.Updates.addNewWildAnimals = function() {
  // var creature = Managers.Creatures.addWildCreature('monkey2', Maps.SUMMER_AREA, 20, 15, Direction.LEFT);
  // Variables.monkey2Id = creature.id;

  // if (Switches.unlockedMonkeys) {
  //   creature = Managers.Creatures.addWildCreature('monkey7', Maps.WINTER_MOUNTAIN_ENTRANCE, 5, 13, Direction.RIGHT);
  //   Variables.monkey3Id = creature.id;
  // }
};

Managers.Updates.replaceCherryBushes = function(content) {
  var farmObjects = content.farmObjects.farmObjects;

  for (var mapId in farmObjects) {
    if (isNaN(mapId)) continue;
    var objects = farmObjects[mapId];

    for (var i = 0; i < objects.length; i++) {
      var obj = objects[i];

      if (!obj) continue;
      if (!obj.cropName) continue;
      if (obj.cropName != 'cherry') continue;

      if (Math.randomInt(3) === 1) {
        obj.cropName = 'raspberry';
      } else {
        obj.cropName = 'blackberry';
      }
    }
  }
};

Managers.Updates.switchBerries = function(content) {
  var farmObjects = content.farmObjects.farmObjects;

  for (var mapId in farmObjects) {
    if (isNaN(mapId)) continue;
    var objects = farmObjects[mapId];

    for (var i = 0; i < objects.length; i++) {
      var obj = objects[i];

      if (!obj) continue;
      if (!obj.cropName) continue;

      if (obj.cropName == 'raspberry') {
        obj.cropName = 'blackberry';
      } else if (obj.cropName == 'blackberry') {
        obj.cropName = 'raspberry';
      }
    }
  }
};

Managers.Updates.addMissingRooster = function() {
  if (!Switches.boughtFestivalAnimal) return;
  if (Managers.Creatures.hasAnyCreatureOfRace('rooster')) return;

  ChickenFestivalContent.roosterIndex = Math.randomInt(8);
  Variables.roosterIndex = ChickenFestivalContent.roosterIndex;

  var creatureType = 'rooster';
  if (Variables.roosterIndex > 0 && Variables.roosterIndex < 8) {
    creatureType += (Variables.roosterIndex + 1);
  }

  var data = Managers.Creatures.prepareCoopCreature(creatureType);
  data.creatureName = 'Glitched';

  Managers.Creatures.createPreparedCreature();

  Managers.Achievements.checkAchievements();
};

Managers.Updates.registerCutsceneEvents = function() {
  if (Switches.playedRaphaelTutorial) {
    Managers.History.registerCutscene('raphael_tutorial');
  }

  if (Switches.playedAnnieIntroduction) {
    Managers.History.registerCutscene('annie_introduction_scene');
  }

  if (Switches.playedChloesFoodBurntEvent) {
    Managers.History.registerCutscene('chloe_food_ruined');
  }

  if (Switches.playedMinimumIntroduction) {
    Managers.History.registerCutscene('minimum_introduction');
  }

  if (Switches.playedMinimumIntroduction2) {
    Managers.History.registerCutscene('minimum_introduction_2');
  }

  if (Switches.playedRaphaelWantingGirlfriend) {
    Managers.History.registerCutscene('raphael_tells_devin_about_wanting_a_girlfriend_scene');
  }

  if (Switches.playedCutsceneFirstTurtle) {
    Managers.History.registerCutscene('brittany_cutscene_first_turtle');
  }

  if (Switches.playedDevinFindingMagicBook) {
    Managers.History.registerCutscene('devin_finds_magic_book');
  }

  if (Switches.raphaelTalkedAboutForest) {
    Managers.History.registerCutscene('raphael_talk_about_forest');
  }

  if (Switches.playedRaphaelForestInvestigation) {
    Managers.History.registerCutscene('raphael_investigating_forest');
  }

  if (Switches.talkedToCurupira) {
    Managers.History.registerCutscene('raphael_investigating_forest_2');
  }
};

Managers.Updates.fixInvalidItemId = function() {
  var items = Managers.Items._container._items;
  var i = 0;

  while (i < items.length) {
    if (!items[i]) {
      items.splice(i, 1);
      continue;
    }

    i++;
  }
};

Managers.Updates.transferActivatedAchievements = function() {
  if (!$gameSystem._activeAchievements) return;

  for (var id in $gameSystem._activeAchievements) {
    if (!$gameSystem._activeAchievements.hasOwnProperty(id)) continue;

    if ($gameSystem._activeAchievements[id]) {
      Managers.Achievements.registerActiveAchievement(id);
    }
  }

  delete $gameSystem._activeAchievements;
};

Managers.Updates.removeRibbonItem = function() {
  Managers.Items.loseItemId('ribbon', Infinity);
  Managers.Items.storageContainer.loseItemId('ribbon', Infinity);
};

Managers.Updates.removeMiaTree = function() {
};

Managers.Updates.pickCurrentItem = function(content) {
  if (!content.currentItem) return;

  if (Managers.Items.itemTypeCanBeStored(content.currentItem.type)) {
    Managers.Items.forceGainItem(content.currentItem);
  } else {
    Managers.Items._specialItem = Managers.Items.currentItem;
    Managers.Items._itemInfo = Managers.Items.currentItemInfo;
  }
};

Managers.Updates.removeOldTasks = function() {
  if (Managers.Tasks.taskData['dont-forget-mom']) {
    delete Managers.Tasks.taskData['dont-forget-mom'];
  }
};

Managers.Updates.clearTaskVariables = function() {
  $gameVariables.setValue(10, 0);
  $gameVariables.setValue(11, 0);
  $gameVariables.setValue(12, 0);
  $gameVariables.setValue(13, 0);
  $gameVariables.setValue(17, 0);
  $gameVariables.setValue(18, 0);
  $gameVariables.setValue(19, 0);
  $gameVariables.setValue(20, 0);
};

Managers.Updates.removeHoldingAnimal = function(content) {
  if (content.specialItemInfo && content.specialItem && content.specialItem.id && content.specialItem.type && content.specialItem.type == 'animal') {
    Managers.Items._specialItem = undefined;
    Managers.Items._itemInfo = undefined;
  }
};

Managers.Updates.addMissingPotatoSeeds = function() {
  if (Managers.Tasks.getTaskStatus('benjamins-payment') != TaskStatus.COMPLETED) return;

  var taskData = Managers.Tasks.getTaskData('benjamins-payment');
  //If it has been more than 10 days, forget it
  if (taskData.completeDate - Managers.Time.totalDays > 10) return;

  if (!Managers.Items.tryPickItemId('potato-seeds', 6)) {
    Managers.Items.mailboxContainer.gainItemId('potato-seeds', 6);
  }
};

Managers.Updates.addGhostItems = function() {
  var maxItems = Managers.Items.maxItemTypes();
  if (Managers.Items.container._items.length > maxItems) {
    var minIdx = Managers.Items.maxItemTypes();
    var itemList = [];

    for (var i = minIdx; i < Managers.Items.container._items.length; i++) {
      var itemData = Managers.Items.container._items[i];
      if (itemData) {
        itemList.push(itemData);
      }

      Managers.Items.container._items[i] = null;
    }

    Managers.Items.container._items = Managers.Items.container._items.slice(0, maxItems);
    itemList.forEach(function(item) {
      Managers.Items.forceGainItem(item);
    });
  }
};

Managers.Updates.replaceSingleWheatItems = function() {
  if (Managers.Items.numItemsById('single-wheat') > 0) {
    Managers.Items.loseItemId('single-wheat', Infinity);
  }

  if (Managers.Items.storageContainer.numItemsById('single-wheat') > 0) {
    Managers.Items.storageContainer.loseItemId('single-wheat', Infinity);
  }

  if (Managers.Items.trashContainer.numItemsById('single-wheat') > 0) {
    Managers.Items.trashContainer.loseItemId('single-wheat', Infinity);
  }

  if (Managers.Items.mailboxContainer.numItemsById('single-wheat') > 0) {
    Managers.Items.mailboxContainer.loseItemId('single-wheat', Infinity);
  }

  for (var mapId in Managers.FarmObjects.farmObjects) {
    if (!Managers.FarmObjects.farmObjects.hasOwnProperty(mapId)) continue;

    var objects = Managers.FarmObjects._farmObjects[mapId];
    for (var i = 0; i < objects.length; i++) {
      var obj = objects[i];
      if (!obj) continue;

      if (obj.itemName == 'single-wheat') {
        obj.itemName = 'coin';
      }
    }
  }
};