require('game/managers/Updates');

Managers.Updates.runV01Updates = function(loadedVersion, content) {
  this.addMigration(0.116, () => {
    this.multiplySeeds(content);
  });

  this.addMigration(0.117, () => {
    this.removeStones117(content);
  });

  this.addMigration(0.118, () => {
    this.fixInvalidRoosters(content);
  });

  this.addMigration(0.120, () => {
    this.recordInitialEarningsAndData(content);
  });

  this.addMigration(0.121, () => {
    this.moveOldForestTrees(content);
    this.moveOldBeachTree(content);
  });

  this.addMigration(0.121, () => {
    this.clearRoosterAchivement(content);
  }, true);

  this.addMigration(0.122, () => {
    this.addCherryTrees(content);
    this.registerOldQuests(content);
    this.moveOldMountainTree(content);
    this.relocatePom(content);
    this.moveMountainRocks(content);
  });

  this.addMigration(0.123, () => {
    this.fixInvalidRoosters2(content);
  });

  this.addMigration(0.1231, () => {
    this.addInitialChickenTraits(content);
  });

  this.addMigration(0.1232, () => {
    this.removeDuplicatedAnimals(content);
  });
};

Managers.Updates.multiplySeeds = function(content) {
  // Before version 0.116, Seeds were worth 4 times as much. If the save file is from that time, multiply any seeds in the inventory by 4.
  var items = content.items;
  for (var i = 0; i < items.length; i++) {
    var item = items[i];

    if (item.id.indexOf('-seeds') > 0) {
      item.amount *= 4;
    }
  }
};

Managers.Updates.removeStones117 = function(content) {
  var farmObjects = content.farmObjects.farmObjects;

  var northWestOrangeTownObjects = farmObjects[29];
  if (northWestOrangeTownObjects) {
    for (var i = 0; i < northWestOrangeTownObjects.length; i++) {
      if (!northWestOrangeTownObjects[i]) continue;

      if (northWestOrangeTownObjects[i].x != 11) continue;
      if (northWestOrangeTownObjects[i].y != 10) continue;
      if (northWestOrangeTownObjects[i]._cropName != 'stone') continue;

      northWestOrangeTownObjects[i]._cropName = '';
      break;
    }
  }

  var forestEntranceObjects = farmObjects[46];
  if (forestEntranceObjects) {
    for (var j = 0; j < forestEntranceObjects.length; j++) {
      if (!forestEntranceObjects[j]) continue;

      if (forestEntranceObjects[j].x != 6) continue;
      if (forestEntranceObjects[j].y != 16) continue;
      if (forestEntranceObjects[j]._cropName != 'stone') continue;

      forestEntranceObjects[j]._cropName = '';
      break;
    }
  }
};

Managers.Updates.fixInvalidRoosters = function(content) {
  var creatures = content.creatures.creatures;

  if (!creatures) return;
  for (var mapId in creatures) {
    if (!creatures.hasOwnProperty(mapId)) continue;

    var mapCreatures = creatures[mapId];
    if (!mapCreatures) continue;

    for (var i = 0; i < mapCreatures.length; i++) {
      if (mapCreatures[i].type == 'rooster1') {
        mapCreatures[i].type = 'rooster2';
      }
    }
  }
};

Managers.Updates.recordInitialEarningsAndData = function(content) {
  var history = {
    daily : {},
    total : {}
  };

  var gold = content.gold;
  var time = content.currentDateTime;

  history.daily[time.year] = {};
  history.daily[time.year][time.month] = {};
  history.daily[time.year][time.month][time.day] = {
    'moneyEarned' : gold
  };

  if (content.switches._data[Switches._gotFirstBag]) {
    history.daily[time.year][time.month][time.day].events = ['got_first_bag'];
  }

  content.history = history;
  content.variables._data[Variables._moneyEarned] = gold;
};

Managers.Updates.moveOldForestTrees = function(content) {
  var farmObjects = content.farmObjects.farmObjects;

  var forestEntranceObjects = farmObjects[46];
  if (forestEntranceObjects) {
    for (var j = 0; j < forestEntranceObjects.length; j++) {
      if (!forestEntranceObjects[j]) continue;

      if (forestEntranceObjects[j].y == 19) {
        forestEntranceObjects[j]._y = 18;
        continue;
      }
    }
  }
};

Managers.Updates.moveOldBeachTree = function(content) {
  var farmObjects = content.farmObjects.farmObjects;

  var forestEntranceObjects = farmObjects[33];
  if (forestEntranceObjects) {
    for (var j = 0; j < forestEntranceObjects.length; j++) {
      if (!forestEntranceObjects[j]) continue;

      if (forestEntranceObjects[j].y != 9) continue;
      if (forestEntranceObjects[j].x != 1) continue;

      forestEntranceObjects[j].x = 3;
      forestEntranceObjects[j].y = 11;
      break;
    }
  }
};

Managers.Updates.clearRoosterAchivement = function() {
  if ($gameSystem._fixedRoosterAchievement) return;

  if (!Managers.Creatures.hasAnyCreatureOfRace('rooster')) {
    Managers.Steam.clearAchievement(Achievements.GET_A_ROOSTER);
  }
  $gameSystem._fixedRoosterAchievement = true;
};

Managers.Updates.addCherryTrees = function() {
  //Changed on version 0.2.6.6 to replace cherry for raspberry

  if ($gameSystem.isMapInitialized(2)) {
    if (!Managers.FarmObjects.hasFarmObjectXy(2, 47, 4)) {
      Managers.FarmObjects.createRaspberryCropAt(2, 47, 4);
    }

    if (!Managers.FarmObjects.hasFarmObjectXy(2, 47, 5)) {
      Managers.FarmObjects.createRaspberryCropAt(2, 47, 5);
    }

    if (!Managers.FarmObjects.hasFarmObjectXy(2, 55, 14)) {
      Managers.FarmObjects.createRaspberryCropAt(2, 55, 14);
    }
  }

  if ($gameSystem.isMapInitialized(39)) {
    if (!Managers.FarmObjects.hasFarmObjectXy(39, 24, 9)) {
      Managers.FarmObjects.createRaspberryCropAt(39, 24, 9);
    }

    if (!Managers.FarmObjects.hasFarmObjectXy(39, 24, 10)) {
      Managers.FarmObjects.createRaspberryCropAt(39, 24, 10);
    }

    if (!Managers.FarmObjects.hasFarmObjectXy(39, 19, 4)) {
      Managers.FarmObjects.createRaspberryCropAt(39, 19, 4);
    }

    if (!Managers.FarmObjects.hasFarmObjectXy(39, 20, 4)) {
      Managers.FarmObjects.createRaspberryCropAt(39, 20, 4);
    }

    if (!Managers.FarmObjects.hasFarmObjectXy(39, 3, 2)) {
      Managers.FarmObjects.createRaspberryCropAt(39, 3, 2);
    }
  }

  if ($gameSystem.isMapInitialized(51)) {
    if (!Managers.FarmObjects.hasFarmObjectXy(51, 3, 14)) {
      Managers.FarmObjects.createRaspberryCropAt(51, 3, 14);
    }
    if (!Managers.FarmObjects.hasFarmObjectXy(51, 5, 16)) {
      Managers.FarmObjects.createRaspberryCropAt(51, 5, 16);
    }
    if (!Managers.FarmObjects.hasFarmObjectXy(51, 6, 19)) {
      Managers.FarmObjects.createRaspberryCropAt(51, 6, 19);
    }
  }

  if ($gameSystem.isMapInitialized(40)) {
    if (!Managers.FarmObjects.hasFarmObjectXy(40, 45, 16)) {
      Managers.FarmObjects.createRaspberryCropAt(40, 45, 16);
    }
  }

  if ($gameSystem.isMapInitialized(46)) {
    if (!Managers.FarmObjects.hasFarmObjectXy(46, 27, 9)) {
      Managers.FarmObjects.createRaspberryCropAt(46, 27, 9);
    }
  }

  if ($gameSystem.isMapInitialized(47)) {
    if (!Managers.FarmObjects.hasFarmObjectXy(47, 9, 11)) {
      Managers.FarmObjects.createRaspberryCropAt(47, 9, 11);
    }
  }
};

Managers.Updates.registerOldQuests = function() {
  var fullData = Managers.Tasks.taskData;
  if (!fullData) return;

  for (var taskId in fullData) {
    var data = Managers.Tasks.taskData[taskId];
    if (!data) continue;

    Managers.History.registerAcceptedTask(taskId);

    if (data.status == TaskStatus.COMPLETED) {
      Managers.History.registerCompletedTask(taskId);
    }
  }
};

Managers.Updates.moveOldMountainTree = function(content) {
  var farmObjects = content.farmObjects.farmObjects;

  var mountainObjects = farmObjects[40];
  if (mountainObjects) {
    for (var j = 0; j < mountainObjects.length; j++) {
      if (!mountainObjects[j]) continue;

      if (mountainObjects[j].y != 11) continue;
      if (mountainObjects[j].x != 36) continue;

      mountainObjects[j].x = 39;
      break;
    }
  }
};

Managers.Updates.relocatePom = function() {
  var pomData = $gameSystem.getExtraData('pom');

  if (pomData) {
    if (pomData.mapId == 49) {
      pomData.mapId = Maps.MOUNTAIN;
      pomData.x = 6;
      pomData.y = 51;
    }

    $gameSystem.setExtraData('pom', pomData);
  }
};

Managers.Updates.moveMountainRocks = function(content) {
  var farmObjects = content.farmObjects.farmObjects;

  var mountainObjects = farmObjects[51];
  if (mountainObjects) {
    for (var j = 0; j < mountainObjects.length; j++) {
      if (!mountainObjects[j]) continue;

      if (mountainObjects[j].y != 9) continue;
      if (mountainObjects[j].x != 64) continue;

      mountainObjects[j].x = 63;
      mountainObjects[j].y = 6;
      break;
    }
  }
};

Managers.Updates.fixInvalidRoosters2 = function(content) {
  var creatures = content.creatures.creatures;

  if (!creatures) return;
  for (var mapId in creatures) {
    if (!creatures.hasOwnProperty(mapId)) continue;

    var mapCreatures = creatures[mapId];
    if (!mapCreatures) continue;

    for (var i = 0; i < mapCreatures.length; i++) {
      var creatureType = mapCreatures[i].type;

      if (creatureType.startsWith('roosterundefined') || creatureType.startsWith('roosterNaN')) {
        creatureType = 'rooster';

        if (Variables.roosterIndex > 0 && Variables.roosterIndex < 8) {
          creatureType += (Variables.roosterIndex + 1);
        }

        mapCreatures[i].type = creatureType;
      }
    }
  }
};


Managers.Updates.addInitialChickenTraits = function(content) {
  var creatures = content.creatures.creatures;

  if (!creatures) return;
  for (var mapId in creatures) {
    if (!creatures.hasOwnProperty(mapId)) continue;

    var mapCreatures = creatures[mapId];
    if (!mapCreatures) continue;

    for (var i = 0; i < mapCreatures.length; i++) {
      var creatureType = mapCreatures[i].type;

      if (creatureType.indexOf('chick') >= 0) {
        mapCreatures[i]._chickenSpeed = 0.1 + Math.randomInt(25) / 10;
        mapCreatures[i]._chickenEggChance = 0.1 + Math.randomInt(25) / 10;
        mapCreatures[i]._chickenLuck = 0.1 + Math.randomInt(25) / 10;
      }
    }
  }
};

Managers.Updates.removeDuplicatedAnimals = function(content) {
  var creatures = content.creatures.creatures;

  if (!creatures) return;
  var i;
  var creatureData;

  function clearList(list) {
    while (list.length > 1) {
      var firstCreatureFriendship = list[0].friendship || 0;
      var secondCreatureFriendship = list[1].friendship || 0;

      if (firstCreatureFriendship > secondCreatureFriendship) {
        Managers.Creatures.removeCreature(list[1]);
        list.splice(1, 1);
      } else {
        Managers.Creatures.removeCreature(list[0]);
        list.splice(0, 1);
      }
    }
  }

  function clearMap(mapId, creatureType) {
    var mapCreatures = creatures[mapId];
    if (mapCreatures && mapCreatures.length >= 2) {
      var list = [];
      for (i = 0; i < mapCreatures.length; i++) {
        creatureData = mapCreatures[i];
        if (!creatureData) continue;

        if (creatureData.type == creatureType) {
          list.push(creatureData);
        }
      }

      clearList(list);
    }
  }

  clearMap(34, 'dog8');
  clearMap(42, 'small-turtle');
  clearMap(42, 'small-turtle7');
  clearMap(13, 'small-turtle8');
  clearMap(32, 'cat');
  clearMap(51, 'cat4');
  clearMap(2, 'cat5');
  clearMap(44, 'cat6');
  clearMap(44, 'dog15');
  clearMap(47, 'squirrel');
};
