require('game/managers/Updates');

function checkMissingBuildings(loadedVersion) {
  const buildings = [].concat(Managers.FarmObjects.getCoopList()).concat(Managers.FarmObjects.getBarnList());

  for (let building of buildings) {
    if (!building) continue;
    if (!building.used) continue;

    const { mapId, x, y } = building;

    const buildingOnPosition = Managers.FarmObjects.getFarmObjectsXy(mapId, x, y, (farmObject) => {
      return farmObject.modelName == 'coop' || farmObject.modelName == 'barn';
    });

    if (!buildingOnPosition) {
      building.used = false;
      Managers.History.registerItem('update-notes', `${ loadedVersion }:disabled-missing-building`);
    }
  }
}

function checkOldHomeCreatures() {
  if (Switches.builtSecondFloor) {
    Managers.Creatures.moveMapCreatures(Maps.HOME, Maps.HOME_3);
    Managers.Creatures.moveMapCreatures(Maps.HOME_2, Maps.HOME_3);
  } else if (Switches.expandedHouse) {
    Managers.Creatures.moveMapCreatures(Maps.HOME, Maps.HOME_2);
  }
}

Managers.Updates.runDataChecks = function(loadedVersion) {
  checkMissingBuildings(loadedVersion);
  checkOldHomeCreatures();
};