require('game/tools/Tool');

Tools.Teleport = class Teleport extends Tools.BaseTool {
  static get energyRequired() {
    return 10;
  }

  static get fatigueRequired() {
    return 0;
  }

  static get toolName() {
    return 'teleport';
  }

  static doAnimation() {
    $gamePlayer.doToolJumpAnimation(this.toolName);
  }

  static doTeleportAnimation() {
    $gamePlayer.requestAnimation(Constants.TELEPORT_ANIMATION);
  }

  static use(/*level*/) {
    Managers.CommonEvent.playEvent('use_teleport');
    $gamePlayer.clearToolData();
    Managers.Player.magicExp++;

    return true;
  }

  static doToolEffect() {
  }

  static getAffectedTiles(/*level, includeInvalid*/) {
    return [];
  }

  static canTeleportToFarm() {
    const contentManagerValue = Managers.Content.canTeleportToFarm();
    if (contentManagerValue === true || contentManagerValue === false) {
      return contentManagerValue;
    }
    return true;
  }

  static canTeleportToOrangeTown() {
    const contentManagerValue = Managers.Content.canTeleportToOrangeTown();
    if (contentManagerValue === true || contentManagerValue === false) {
      return contentManagerValue;
    }

    return true;
  }

  static canTeleportToMountains() {
    const contentManagerValue = Managers.Content.canTeleportToMountains();
    if (contentManagerValue === true || contentManagerValue === false) {
      return contentManagerValue;
    }

    return $gameSystem.isMapInitialized(Maps.MOUNTAIN);
  }

  static canTeleportToMountainCave() {
    const contentManagerValue = Managers.Content.canTeleportToMountainCave();
    if (contentManagerValue === true || contentManagerValue === false) {
      return contentManagerValue;
    }

    return false;
  }

  static canTeleportToForest() {
    const contentManagerValue = Managers.Content.canTeleportToForest();
    if (contentManagerValue === true || contentManagerValue === false) {
      return contentManagerValue;
    }

    return $gameSystem.isMapInitialized(Maps.FOREST);
  }

  static canTeleportToSpringFields() {
    const contentManagerValue = Managers.Content.canTeleportToSpringFields();
    if (contentManagerValue === true || contentManagerValue === false) {
      return contentManagerValue;
    }

    return $gameSystem.isMapInitialized(Maps.SPRING_FIELDS);
  }

  static canTeleportToSummerFields() {
    const contentManagerValue = Managers.Content.canTeleportToSummerFields();
    if (contentManagerValue === true || contentManagerValue === false) {
      return contentManagerValue;
    }

    return $gameSystem.isMapInitialized(Maps.SUMMER_AREA);
  }

  static canTeleportToFallFields() {
    const contentManagerValue = Managers.Content.canTeleportToFallFields();
    if (contentManagerValue === true || contentManagerValue === false) {
      return contentManagerValue;
    }

    return $gameSystem.isMapInitialized(Maps.FALL_FIELDS);
  }

  static canTeleportToWinterFields() {
    const contentManagerValue = Managers.Content.canTeleportToWinterFields();
    if (contentManagerValue === true || contentManagerValue === false) {
      return contentManagerValue;
    }

    return $gameSystem.isMapInitialized(Maps.WINTER_FARM);
  }

  static addTeleportLocations(interpreter) {
    if (this.canTeleportToFarm()) {
      interpreter.addChoice('My Farm');
    }

    if (this.canTeleportToOrangeTown()) {
      interpreter.addChoice('Orange Town');
    }

    if (this.canTeleportToMountains()) {
      interpreter.addChoice('Mountains');
    }

    if (this.canTeleportToMountainCave()) {
      interpreter.addChoice('Mountain Cave');
    }

    if (this.canTeleportToForest()) {
      interpreter.addChoice('Forest');
    }

    if (this.canTeleportToSpringFields()) {
      interpreter.addChoice('Spring Fields');
    }

    if (this.canTeleportToSummerFields()) {
      interpreter.addChoice('Summer Fields');
    }

    if (this.canTeleportToFallFields()) {
      interpreter.addChoice('Fall Fields');
    }

    if (this.canTeleportToWinterFields()) {
      interpreter.addChoice('Winter Fields');
    }

    Managers.Content.addAdditionalTeleportLocations(interpreter);
  }

  static performTeleport(response) {
    this.affectHealth();
    Managers.Content.performTeleport(response);

    if ($gamePlayer.isTransferring()) return;

    switch(response) {
      case 'My Farm':
        $gamePlayer.reserveTransfer(Maps.FARM, 34, 9, Direction.DOWN, 0, true);
        return;
      case 'Orange Town':
        $gamePlayer.reserveTransfer(Maps.ORANGE_TOWN, 1, 46, Direction.RIGHT, 0, true);
        return;
      case 'Mountains':
        $gamePlayer.reserveTransfer(Maps.MOUNTAIN, 56, 72, Direction.UP, 0, true);
        return;
      case 'Mountain Cave':
        $gamePlayer.reserveTransfer(Maps.MAIN_MINE, 57, 71, Direction.UP, 0, true);
        return;
      case 'Forest':
        $gamePlayer.reserveTransfer(Maps.FOREST, 3, 61, Direction.RIGHT, 0, true);
        return;
      case 'Spring Fields':
        $gamePlayer.reserveTransfer(Maps.SPRING_FIELDS, 2, 10, Direction.RIGHT, 0, true);
        return;
      case 'Summer Fields':
        $gamePlayer.reserveTransfer(Maps.SUMMER_AREA, 11, 23, Direction.UP, 0, true);
        return;
      case 'Fall Fields':
        $gamePlayer.reserveTransfer(Maps.FALL_FIELDS, 5, 18, Direction.DOWN, 0, true);
        return;
      case 'Winter Fields':
        $gamePlayer.reserveTransfer(Maps.WINTER_FARM, 13, 22, Direction.UP, 0, true);
        return;
    }
  }
};

Managers.Tools.registerTool(Tools.Teleport);