require('game/tools/Tool');

Tools.Sickle = class BaseSickle extends Tools.BaseTool {
  static get spriteName() {
    return 'metal_tools[4]_iron';
  }

  static get spriteIndex() {
    return 3;
  }

  static get level() {
    return 0;
  }

  static get toolName() {
    return '';
  }

  static get effectDelay() {
    return Utils.getFrameCount(100);
  }

  static get energyRequired() {
    return 8;
  }

  static checkWeedStatus(weed, customClear) {
    weed.hp = 4;

    $gameTemp.setTimeout(() => {
      weed.hp = 3;
      weed.updateEvents();

      $gameTemp.setTimeout(() => {
        weed.hp = 2;
        weed.updateEvents();

        $gameTemp.setTimeout(() => {
          weed.hp = 1;
          weed.updateEvents();

          $gameTemp.setTimeout(() => {
            if (customClear === false) {
              return;
            }

            weed.clear();
            weed.updateEvents();
          }, 3);
        }, 3);
      }, 3);
    }, 3);
  }

  static doToolEffect(level, targetTile) {
    const tiles = this.getAffectedTiles(level, false, TouchInput.wasMouseUsed(), targetTile);
    let playSound = false;
    let playedAnimation = false;

    let grassAmount = 0;
    let firstTile = false;
    let weedItemId = 'weeds';
    let seedItemId = false;

    for (let i = 0; i < tiles.length; i++) {
      const tile = tiles[i];
      const farmObjects = Managers.FarmObjects.getFarmObjectsXy($gameMap._mapId, tile.x, tile.y);
      let shouldBreak = false;

      for (let j = 0; j < farmObjects.length; j++) {
        const farmObject = farmObjects[j];
        if (farmObject === undefined) continue;
        if (farmObject.modelName == FarmObjectState.GRASS) continue;

        const state = farmObject.state;
        const cropStates = [
          Constants.FarmObjectState.SPOILED_CROP,
          Constants.FarmObjectState.SMALL_CROP,
          Constants.FarmObjectState.MEDIUM_CROP,
          Constants.FarmObjectState.BIG_CROP,
        ];

        const otherStates = [
          Constants.FarmObjectState.WEED,
          Constants.FarmObjectState.NEW_GRASS
        ];

        if (otherStates.indexOf(state) < 0 && cropStates.indexOf(state) < 0) {
          continue;
        }
        if (farmObject.isTree()) continue;

        if (!playedAnimation) {
          playedAnimation = true;
        }

        this.affectHealth(0);
        playSound = true;

        if (!firstTile) {
          firstTile = tile;
        }

        if (state == FarmObjectState.WEED) {
          const customClear = Managers.Content.onClearObject(farmObject);

          this.checkWeedStatus(farmObject, customClear);

          if (customClear === true || customClear === false) {
            grassAmount = 0;
            shouldBreak = true;
            seedItemId = false;
            playSound = false;
            break;
          }

          grassAmount++;

          switch (Managers.Time.mapMonth) {
            case Seasons.FALL:
              weedItemId = 'yellow-weeds';
              break;
          }

          Managers.Player.sickleExp++;
          continue;
        } else if (state == FarmObjectState.NEW_GRASS) {
          grassAmount++;
        } else if (cropStates.indexOf(state) >= 0) {
          const cropName = farmObject.cropName;
          const seedData = Managers.Items.getItemData(`${cropName}-seeds`);
          if (seedData && !seedData.disabled) {
            const chance = (seedData.daysToRegrow ? 5 : 30) * (level + 1);
            if (Math.randomInt(100) < chance) {
              seedItemId = seedData.id;
            }
          }
        }

        if (farmObject.isFlower && farmObject.isFlower()) {
          farmObject.tilled = false;
        }

        farmObject.modelName   = '';
        farmObject.points = 0;
        farmObject.spoiled = false;
        farmObject.lastFruit = false;
        farmObject.age = 0;

        Managers.Player.sickleExp++;
        farmObject.updateEvents();
      }

      if (shouldBreak) {
        break;
      }
    }

    if (grassAmount > 0 && firstTile) {
      Managers.Items.storageContainer.gainItemId(weedItemId, grassAmount);
    }

    if (playSound) {
      Managers.Sound.playSickle();
    }

    if (seedItemId) {
      Managers.Items.tryPickItemId(seedItemId);
    }

    Managers.FarmObjects.clearEmptyItems();
  }

  static callToolAnimation() {
    $gamePlayer.doToolAnimation(this.toolName, 1, 60);
  }

  static use(level, targetTile = null) {
    const oldStaminaLevel = Managers.Health.staminaLevel;
    this.doAnimation();

    this.affectHealth(0);
    setTimeout(() => {
      Managers.Sound.playSwing();
      this.doToolEffect(level, targetTile);
      Managers.Health.oldStaminaLevel = oldStaminaLevel;
    }, this.effectDelay);
  }

  static filterInvalidTiles(tiles) {
    const validTiles = [];
    const heightLevel = $gamePlayer.getHeightLevel();

    let hasNonCrops = false;
    let hasCrops = false;

    for (let i = 0; i < tiles.length; i++) {
      if (hasCrops) {
        break;
      }

      const tile = tiles[i];
      tile.valid = false;
      if (Managers.Map.getHeightLevel(tile.x, tile.y) != heightLevel) continue;

      const farmObjects = Managers.FarmObjects.getFarmObjectsXy($gameMap._mapId, tile.x, tile.y);

      for (let j = 0; j < farmObjects.length; j++) {
        const farmObject = farmObjects[j];
        if (farmObject === undefined) continue;

        tile.valid = true;

        const state = farmObject.state;

        const cropStates = [];
        const otherStates = [];

        otherStates.push(Constants.FarmObjectState.WEED);
        otherStates.push(Constants.FarmObjectState.SPOILED_CROP);
        otherStates.push(Constants.FarmObjectState.NEW_GRASS);
        cropStates.push(Constants.FarmObjectState.SMALL_CROP);
        cropStates.push(Constants.FarmObjectState.MEDIUM_CROP);
        cropStates.push(Constants.FarmObjectState.BIG_CROP);

        if (otherStates.indexOf(state) < 0 && cropStates.indexOf(state) < 0) {
          continue;
        }

        if (cropStates.indexOf(state) >= 0) {
          if (hasNonCrops) {
            continue;
          }

          const model = farmObject.getFarmObjectType();
          if (!model || !model.canBeCut()) {
            continue;
          }

          hasCrops = true;
        } else {
          hasNonCrops = true;
        }

        if (farmObject.isTree()) continue;

        tile.farmObject = farmObject;
        validTiles.push(tile);
        break;
      }
    }

    return validTiles;
  }

  static getAffectedTiles(level, includeInvalid, useCurrentMousePosition, targetTile = null) {
    if (level === undefined) level = this.level;

    const initialTile = targetTile || this.targetTile(useCurrentMousePosition);
    const allTiles = this.getBasicAffectedTiles(initialTile, level);

    const validTiles = this.filterInvalidTiles(allTiles);

    return validTiles;
  }

  static getBasicAffectedTiles(initialTile, level) {
    if (level === undefined) level = this.level;
    if (level > this.level) level = this.level;

    const tiles = [];
    if (initialTile) {
      tiles.push(initialTile);

      const direction = $gamePlayer.directionToPosition(initialTile.x, initialTile.y);
      const rightDirection = DirectionHelper.rightSide(direction);
      const leftDirection = DirectionHelper.leftSide(direction);

      if (level < 2) {
        const leftTile = initialTile.tileAtDirection(leftDirection);
        const rightTile = initialTile.tileAtDirection(rightDirection);

        let screenLeft;
        let screenRight;
        let screenTop;
        let screenBottom;

        switch ($gamePlayer._direction) {
          case Direction.UP :
            screenLeft = leftTile;
            screenRight = rightTile;
            break;
          case Direction.DOWN :
            screenLeft = rightTile;
            screenRight = leftTile;
            break;
          case Direction.LEFT :
            screenBottom = leftTile;
            screenTop = rightTile;
            break;
          case Direction.RIGHT :
            screenBottom = rightTile;
            screenTop = leftTile;
            break;
        }

        if (screenLeft) {
          if ($gamePlayer.left - screenLeft.x < 0.9) {
            tiles.push(screenLeft);
          }
        }

        if (screenRight) {
          if (screenRight.x - $gamePlayer.right < -0.2) {
            tiles.push(screenRight);
          }
        }

        if (screenTop) {
          if ($gamePlayer.top - screenTop.y < 0.9) {
            tiles.push(screenTop);
          }
        }

        if (screenBottom) {
          if (screenBottom.y - $gamePlayer.bottom < -0.2) {
            tiles.push(screenBottom);
          }
        }
      }

      if (level > 0) {
        const nextTile = initialTile.tileAtDirection(direction);
        tiles.push(nextTile);

        if (level > 1) {

          tiles.push(initialTile.tileAtDirection(rightDirection));
          tiles.push(initialTile.tileAtDirection(leftDirection));

          if (nextTile !== undefined) {
            tiles.push(nextTile.tileAtDirection(rightDirection));
            tiles.push(nextTile.tileAtDirection(leftDirection));

            if (level > 2) {
              const lastTile = nextTile.tileAtDirection(direction);

              if (lastTile !== undefined) {
                tiles.push(lastTile);
                tiles.push(lastTile.tileAtDirection(rightDirection));
                tiles.push(lastTile.tileAtDirection(leftDirection));
              }
            }
          }
        }
      }
    }

    const basicTiles = [];
    for (let i = 0; i < tiles.length; i++) {
      if (tiles[i] !== undefined) {
        basicTiles.push(tiles[i]);
      }
    }

    return basicTiles;
  }

  static isTileBetterThanDefault(x, y) {
    return this.checkIfTileIsBetterThanDefault(x, y);
  }

  static shouldBeUsedOnEvent(event) {
    const farmObjectData = event._farmObjectData;
    const modelName = farmObjectData.modelName;

    if (modelName == FarmObjectState.SMALL_WEED || modelName == FarmObjectState.WEED) {
      return true;
    }

    if (farmObjectData.isCropOrTree) {
      const farmObjectType = farmObjectData.getFarmObjectType();
      if (farmObjectType) {
        const stageCaps = farmObjectType.getStageCaps && farmObjectType.getStageCaps();
        if (stageCaps && stageCaps.length) {
          if (farmObjectType.stage(farmObjectData) === 0) {
            return false;
          }

          if (farmObjectType.isTree()) {
            return false;
          }

          if (farmObjectType.isModel(Models.BushCrop)) {
            return false;
          }

          return true;
        }
      }
    }

    return false;
  }

};

Managers.Tools.registerTool(Tools.Sickle);