require('game/tools/Tool');

Tools.FishingRod = class FishingRod extends Tools.BaseTool {
  static get spriteName() {
    return 'light_tools[4]';
  }

  static get spriteIndex() {
    return 0;
  }

  static get level() {
    return 0;
  }

  static get usageDistance() {
    return 2;
  }

  static get toolName() {
    return 'fishing-rod';
  }

  static doToolEffect(/*level*/) {
  }

  static endToolAnimation() {
    Managers.Fishing.startFishing(this.level);
  }

  static startFishing(tile) {
    Managers.Fishing.registerFishingTile(tile);

    this.doCustomAnimation(() => {
      $gamePlayer.doToolAnimation(this.toolName, undefined, undefined, undefined, this.endToolAnimation.bind(this));
    });

    Managers.Player.fishingExp++;
    this.affectHealth(this.level);
  }

  static use(level, targetTile = null) {
    const oldStaminaLevel = Managers.Health.staminaLevel;
    const tiles = this.getAffectedTiles(level, false, false);
    if (tiles.length > 0) {
      this.startFishing(tiles[0]);
    } else {
      this.doAnimation();
    }

    this.affectHealth(level);
    setTimeout(() => {
      this.doToolEffect(level);
      Managers.Health.oldStaminaLevel = oldStaminaLevel;
    }, this.effectDelay);
  }

  static isTileValid(tile, usingMouse = false) {
    const playerHeightLevel = $gamePlayer.getHeightLevel();
    let tileHeightLevel = Managers.Map.getHeightLevel(tile.x, tile.y);
    const oldTileHeightLevel = tileHeightLevel;

    if (tileHeightLevel > playerHeightLevel) {
      return false;
    }
    if (tileHeightLevel < playerHeightLevel) {
      tile.y += (playerHeightLevel - tileHeightLevel);
      tileHeightLevel = Managers.Map.getHeightLevel(tile.x, tile.y);
      if (tileHeightLevel != oldTileHeightLevel) {
        return false;
      }
    }

    if ($gameMap.terrainTag(tile.x, tile.y) !== TerrainTags.WATER) {
      return false;
    }

    const regionId = $gameMap.regionId(tile.x, tile.y);
    if (regionId === Region.BLOCK_FISHING || regionId == Region.BRIDGE) {
      return false;
    }

    if (Managers.Map.mapMonth($gameMap._mapId) == Seasons.WINTER) {
      if (regionId == Region.BLOCK_FISHING_ON_WINTER) {
        return false;
      }
    }

    return true;
  }

  static isTileValidForMouseDown(tile) {
    return this.isTileValid(tile, true);
  }

  static getAffectedTiles(level, includeInvalid) {
    if (level === undefined) level = this.level;

    const allTiles = super.getAffectedTiles.call(this, level);
    const validTiles = [];

    for (let i = 0; i < allTiles.length; i++) {
      const tile = allTiles[i];

      if (!this.isTileValid(tile)) {
        continue;
      }

      validTiles.push(tile);
    }

    return validTiles;
  }
};

Managers.Tools.registerTool(Tools.FishingRod);