require('game/tools/Tool');

Tools.Sprinkler = class Sprinkler extends Tools.BaseTool {
  static get toolName() {
    return 'sprinkler';
  }

  static get modelName() {
    return this.toolName;
  }

  static doToolEffect(/*level*/) {
    const tile = TileHelper.getSmartFrontTile(1);

    const farmObjects = Managers.FarmObjects.getFarmObjectsXy($gameMap._mapId, tile.x, tile.y);
    for (let i = 0; i < farmObjects.length; i++) {
      const farmObject = farmObjects[i];

      if (farmObject.isCropOrTree) return;
      if (farmObject.hasCollision()) {
        return;
      }
    }

    if (Managers.FarmObjects.isTileProtected($gameMap._mapId, tile.x, tile.y)) return;
    //Allow sprinkler objects on any tile even if they aren't soil
    if (!TileHelper.checkIfTileCanGetObject(tile.x, tile.y, true, this.modelName, false, false)) {
      return;
    }

    if ($gamePlayer) {
      $gamePlayer.delayItemSprite();
      $gamePlayer.doToolDelayAnimation(this.toolName);
    }

    for (let i = 0; i < farmObjects.length; i++) {
      const replacedFarmObject = farmObjects[i];
      if (!replacedFarmObject) continue;
      if (replacedFarmObject.tilled) {
        replacedFarmObject.tilled = false;
        replacedFarmObject.updateEvents(true, false);
      }
    }


    const sprinkler = Managers.FarmObjects.createFarmObjectAt($gameMap._mapId, tile.x, tile.y, this.modelName);
    Managers.Sound.playDropItem();
    sprinkler.updateEvents(true, false);
    Managers.Items.loseItemId(this.toolName);
    $gamePlayer.leaveTile(tile.x, tile.y);
  }

  static use(level, targetTile = null) {
    this.doToolEffect(level);
  }

  static getAffectedTiles(level, includeInvalid) {
    const tile = TileHelper.getSmartFrontTile(1);

    const farmObjects = Managers.FarmObjects.getFarmObjectsXy($gameMap._mapId, tile.x, tile.y);
    for (let i = 0; i < farmObjects.length; i++) {
      const farmObject = farmObjects[i];

      if (farmObject.hasCollision()) {
        if (!includeInvalid) return [];
        tile.valid = false;
      }
    }

    if (Managers.FarmObjects.isTileProtected($gameMap._mapId, tile.x, tile.y)) {
      if (!includeInvalid) return [];
      tile.valid = false;
    }

    //Don't show the highlight on tiles that aren't soil.
    if (!Managers.FarmObjects.tileIsSoil(tile.x, tile.y)) {
      if ($gameMap.regionId(tile.x, tile.y) != Region.GRASSY_FARM) {
        return [];
      }
    }

    tile.valid = true;
    return [tile];
  }
};

Managers.Tools.registerTool(Tools.Sprinkler);