require('game/tools/Tool');

Tools.Hay = class Hay extends Tools.BaseTool {
  static get toolName() {
    return 'hay';
  }

  static doToolEffect(level, targetTile = null) {
    const tile = targetTile || TileHelper.getSmartFrontTile(1);

    const events = $gameMap.eventsXy(tile.x, tile.y);
    if (events.length === 0) return false;

    for (let i = 0; i < events.length; i++) {
      if (events[i]._name == 'hay') {
        const key = [$gameMap._mapId, events[i]._eventId, 'A'];

        if ($gameSelfSwitches.value(key)) {
          return false;
        }

        if ($gamePlayer) {
          $gamePlayer.delayItemSprite();
          $gamePlayer.doToolDelayAnimation(this.toolName);
        }

        Managers.Items.loseItemId(this.toolName, 1);
        $gameSelfSwitches.setValue(key, true);
        Managers.Sound.playDropItem();
        return true;
      }
    }

    return false;
  }

  static use(level, targetTile = null) {
    if (!this.doToolEffect(level, targetTile)) {
      Managers.Items.dropItem(true, true);
    }
  }

  static getAffectedTiles(level, includeInvalid) {
    return [];
  }

  static isTileBetterThanDefault(x, y) {
    return this.checkIfTileIsBetterThanDefault(x, y);
  }

  static isTileValid(tile, usingMouse = false) {
    if ($gameMap._realMapId !== Maps.BARN) return false;

    const events = $gameMap.eventsXy(tile.x, tile.y);
    if (events.length === 0) {
      return false;
    }

    for (let i = 0; i < events.length; i++) {
      if (events[i]._name != 'hay') {
        continue;
      }

      if ($gameSelfSwitches.value([$gameMap._mapId, events[i]._eventId, 'A'])) {
        return false;
      } else {
        return true;
      }
    }

    return false;
  }

  static isTileValidForMouseDown(tile) {
    return this.isTileValid(tile, true);
  }
};

Managers.Tools.registerTool(Tools.Hay);