require('game/tools/Tool');

Tools.Gate = class Gate extends Tools.BaseTool {
  static get toolName() {
    return 'gate';
  }

  static doToolEffect(level) {
    const tiles = this.getAffectedTiles(level, false, false);
    if (tiles.length === 0) return;

    const tile = tiles[0];

    if ($gamePlayer) {
      $gamePlayer.delayItemSprite();
      $gamePlayer.doToolDelayAnimation(this.toolName);
    }

    const gate = Managers.FarmObjects.createFarmObjectAt($gameMap._mapId, tile.x, tile.y, FarmObjectState.GATE);
    Managers.Sound.playDropItem();
    gate.updateEvents(true, true);
    Managers.Items.loseItemId(this.toolName);
    $gamePlayer.leaveTile(tile.x, tile.y);
  }

  static use(level, targetTile = null) {
    this.doToolEffect(level);
  }

  static getAffectedTiles(level, includeInvalid) {
    const tile = TileHelper.getSmartFrontTile(1);
    const farmObjects = Managers.FarmObjects.getFarmObjectsXy($gameMap._mapId, tile.x, tile.y);
    for (let i = 0; i < farmObjects.length; i++) {
      const farmObject = farmObjects[i];

      if (farmObject.hasCollision()) {
        if (!includeInvalid) return [];
        tile.valid = false;
      }
    }

    if (Managers.FarmObjects.isTileProtected($gameMap._mapId, tile.x, tile.y)) {
      if (!includeInvalid) return [];
      tile.valid = false;
    }

    const top = Managers.FarmObjects.isFenceObject($gameMap._mapId, tile.x, tile.y - 1);
    const left = Managers.FarmObjects.isFenceObject($gameMap._mapId, tile.x -1, tile.y);
    const right = Managers.FarmObjects.isFenceObject($gameMap._mapId, tile.x + 1, tile.y);
    const bottom = Managers.FarmObjects.isFenceObject($gameMap._mapId, tile.x, tile.y + 1);

    if (!top && !left && !right && !bottom) return [];

    if (!!top || !!bottom) {
      if (!!left || !!right) {
        if (!includeInvalid) return [];

        tile.valid = false;
      } else {
        tile.valid = true;
      }
    } else {
      if (!!left || !!right) {
        tile.valid = true;
      }
    }

    return [tile];
  }
};

Managers.Tools.registerTool(Tools.Gate);