require('game/tools/Tool');

Tools.Fence = class Fence extends Tools.BaseTool {
  static get toolName() {
    return 'fence';
  }

  static doToolEffect(/*level*/) {
    if (PlayerFarmMaps.indexOf($gameMap._mapId) < 0) return;

    const tile = TileHelper.getSmartFrontTile(1);

    const farmObjects = Managers.FarmObjects.getFarmObjectsXy($gameMap._mapId, tile.x, tile.y);
    for (let i = 0; i < farmObjects.length; i++) {
      const farmObject = farmObjects[i];

      if (farmObject.hasCollision()) {
        return;
      }
    }

    if (Managers.FarmObjects.isTileProtected($gameMap._mapId, tile.x, tile.y)) return;
    //Allow fence objects on any tile even if they aren't soil

    if (!TileHelper.checkIfTileCanGetObject(tile.x, tile.y, true, 'fence', true, false, false)) {
      return;
    }

    if ($gamePlayer) {
      $gamePlayer.delayItemSprite();
      $gamePlayer.doToolDelayAnimation(this.toolName);
    }

    const fence = Managers.FarmObjects.createFarmObjectAt($gameMap._mapId, tile.x, tile.y, 'fence');
    Managers.Sound.playDropItem();
    fence.updateEvents(true, true);
    Managers.Items.loseItemId(this.toolName);
    $gamePlayer.leaveTile(tile.x, tile.y);
  }

  static getAffectedTiles(level, includeInvalid) {
    if (PlayerFarmMaps.indexOf($gameMap._mapId) < 0) return [];

    const tile = TileHelper.getSmartFrontTile(1);

    const farmObjects = Managers.FarmObjects.getFarmObjectsXy($gameMap._mapId, tile.x, tile.y);
    for (let i = 0; i < farmObjects.length; i++) {
      const farmObject = farmObjects[i];

      if (farmObject !== undefined && farmObject.hasCollision()) {
        if (!includeInvalid) return [];
        tile.valid = false;
      }
    }

    if (Managers.FarmObjects.isTileProtected($gameMap._mapId, tile.x, tile.y)) {
      if (!includeInvalid) return [];
      tile.valid = false;
    }

    tile.valid = true;

    return [tile];
  }

  static use(level, targetTile = null) {
    this.doToolEffect(level);
  }
};

Managers.Tools.registerTool(Tools.Fence);