require('game/tools/Tool');

Tools.ChickenFeed = class ChickenFeed extends Tools.BaseTool {
  static get toolName() {
    return 'chicken-feed';
  }

  static doToolEffect(/*level*/) {
    const tile = TileHelper.getSmartFrontTile(1);

    const events = $gameMap.eventsXy(tile.x, tile.y);
    if (events.length === 0) return false;

    for (let i = 0; i < events.length; i++) {
      if (events[i].event().name == 'chicken-feed') {
        const key = [$gameMap._mapId, events[i]._eventId, 'A'];

        if ($gameSelfSwitches.value(key)) {
          return false;
        }

        if ($gamePlayer) {
          $gamePlayer.delayItemSprite();
          $gamePlayer.doToolDelayAnimation(this.toolName);
        }

        Managers.Items.loseItemId(this.toolName, 1);
        $gameSelfSwitches.setValue(key, true);
        Managers.Sound.playDropItem();
        return true;
      }
    }

    return false;
  }

  static use(level, targetTile = null) {
    if (!this.doToolEffect(level)) {
      Managers.Items.dropItem(false, true);
    }
  }

  static getAffectedTiles(/*level, includeInvalid*/) {
    if ($gameMap._realMapId !== Maps.COOP) return [];

    const tile = TileHelper.getSmartFrontTile(1);
    const events = $gameMap.eventsXy(tile.x, tile.y);
    if (events.length === 0) return [];

    for (let i = 0; i < events.length; i++) {
      if (events[i].event().name == 'chicken-feed') {
        if ($gameSelfSwitches.value([$gameMap._mapId, events[i]._eventId, 'A'])) {
          tile.valid = false;
        } else {
          tile.valid = true;
        }

        return [tile];
      }
    }

    return [];
  }

  static isTileBetterThanDefault(x, y) {
    return this.checkIfTileIsBetterThanDefault(x, y);
  }

  static isTileValid(tile, usingMouse = false) {
    if ($gameMap._realMapId !== Maps.COOP) return false;

    const events = $gameMap.eventsXy(tile.x, tile.y);
    if (events.length === 0) {
      return false;
    }

    for (let i = 0; i < events.length; i++) {
      if (events[i].event().name != 'chicken-feed') {
        continue;
      }

      if ($gameSelfSwitches.value([$gameMap._mapId, events[i]._eventId, 'A'])) {
        return false;
      } else {
        return true;
      }
    }

    return false;
  }

  static isTileValidForMouseDown(tile) {
    return this.isTileValid(tile, true);
  }

};

Managers.Tools.registerTool(Tools.ChickenFeed);