require('game/tools/Tool');

Tools.Chest = class Chest extends Tools.BaseTool {
  static get toolName() {
    return 'chest';
  }

  static doToolEffect(/*level*/) {
    const tile = TileHelper.getSmartFrontTile(1);

    const farmObject = Managers.FarmObjects.getFarmObject($gameMap._mapId, tile.x, tile.y);
    if (farmObject !== undefined && farmObject.state != Constants.FarmObjectState.NONE) return;
    if (Managers.FarmObjects.isTileProtected($gameMap._mapId, tile.x, tile.y)) return;
    //Allow chest objects on any tile even if they aren't soil

    if ($gamePlayer) {
      $gamePlayer.delayItemSprite();
    }

    $gamePlayer.doToolDelayAnimation(this.toolName);

    const chest = Managers.FarmObjects.createObjectAt($gameMap._mapId, tile.x, tile.y, FarmObjectState.CHEST);
    chest.updateEvents(true, true);
    Managers.Items.loseItemId(this.toolName);
    $gamePlayer.leaveTile(tile.x, tile.y);
  }

  static use(level, targetTile = null) {
    this.doToolEffect(level);
  }

  static getAffectedTiles(level, includeInvalid) {
    const tile = TileHelper.getSmartFrontTile(1);

    const farmObject = Managers.FarmObjects.getFarmObject($gameMap._mapId, tile.x, tile.y);
    if (farmObject !== undefined && farmObject.state != Constants.FarmObjectState.NONE) {
      if (!includeInvalid) return [];
      tile.valid = false;
    }
    if (Managers.FarmObjects.isTileProtected($gameMap._mapId, tile.x, tile.y)) {
      if (!includeInvalid) return [];
      tile.valid = false;
    }

    tile.valid = true;
    return [tile];
  }
};

Managers.Tools.registerTool(Tools.Chest);