require('game/tools/Tool');

Tools.Hoe = class BaseHoe extends Tools.BaseTool {
  static get spriteName() {
    return 'metal_tools[4]_iron';
  }

  static get spriteIndex() {
    return 2;
  }

  static get level() {
    return 0;
  }

  static get energyRequired() {
    return 5;
  }

  static get toolName() {
    return '';
  }

  static checkNestStatus(nest, customClear) {
    nest.hp = 6;
    nest.updateEvents();

    $gameTemp.setTimeout(() => {
      nest.hp = 5;
      nest.updateEvents();

      $gameTemp.setTimeout(() => {
        nest.hp = 4;
        nest.updateEvents();

        $gameTemp.setTimeout(() => {
          nest.hp = 3;
          nest.updateEvents();

          $gameTemp.setTimeout(() => {
            nest.hp = 2;
            nest.updateEvents();

            $gameTemp.setTimeout(() => {
              nest.hp = 1;
              nest.updateEvents();

              $gameTemp.setTimeout(() => {
                if (customClear === false) {
                  return;
                }

                nest.modelName = FarmObjectState.DIRT;
                nest.updateEvents();
              }, 3);
            }, 3);
          }, 3);
        }, 3);
      }, 3);
    }, 3);
  }

  static doToolEffect(level, targetTile = null) {
    let realLevel = level;
    if (level <= -100) {
      realLevel = Math.abs(level) - 100;
    }

    const tiles = this.getAffectedTiles(realLevel, false, false, targetTile);
    let playedSound = false;

    for (let i = 0; i < tiles.length; i++) {
      const tile = tiles[i];
      let farmObject = Managers.FarmObjects.getFarmObject($gameMap._mapId, tile.x, tile.y);
      if (farmObject === undefined) {
        farmObject = Managers.FarmObjects.createFarmObjectAt($gameMap._mapId, tile.x, tile.y);
      }

      if (farmObject.modelName == FarmObjectState.GRASS) {
        farmObject.clear();
        farmObject.updateEvents(true, true);
      } else if (farmObject.modelName == FarmObjectState.TERMITE_NEST) {
        const customClear = Managers.Content.onClearObject(farmObject);
        this.checkNestStatus(farmObject, customClear);

        if (customClear === true) {
          return;
        }
      } else {
        farmObject.clear();
        farmObject.tilled = true;
        Managers.Player.farmingExp++;
        Managers.Player.hoeExp++;

        if (Managers.Weather.isRaining()) {
          farmObject.watered = true;
        }
        farmObject.updateEvents(true);
      }

      this.affectHealth(0);

      if (!playedSound) {
        Managers.Sound.playHoe();
        playedSound = true;
      }
    }
  }

  static callToolAnimation() {
    const delay = 120 - (this.level * 20);
    $gamePlayer.doToolAnimation(this.toolName, 1, delay);
  }

  static use(level, targetTile = null) {
    this.doAnimation();
    const oldStaminaLevel = Managers.Health.staminaLevel;

    setTimeout(() => {
      Managers.Sound.playSwing();
      this.doToolEffect(level * -1 - 100, targetTile);
      Managers.Health.oldStaminaLevel = oldStaminaLevel;
    }, this.effectDelay);
  }

  static isTileValid(tile, usingMouse = false) {
    const heightLevel = $gamePlayer.getHeightLevel();
    if (Managers.Map.getHeightLevel(tile.x, tile.y) != heightLevel) {
      return false;
    }

    const farmObject = Managers.FarmObjects.getFarmObject($gameMap._mapId, tile.x, tile.y);
    if (farmObject === undefined) {
      if (!tile.isSoil()) {
        return false;
      }

      if ($gameMap.positionHasEvents(tile.x, tile.y)) {
        return false;
      }

      if (Managers.FarmObjects.isTileProtected($gameMap._mapId, tile.x, tile.y)) {
        return false;
      }
    } else {
      const state = farmObject.state;
      const allowedStates = [FarmObjectState.NONE, FarmObjectState.SEED, FarmObjectState.SPOILED_SEED, FarmObjectState.GRASS, FarmObjectState.TERMITE_NEST];
      if (allowedStates.indexOf(state) < 0) {
        return false;
      }

      if (usingMouse) {
        // To kill a seed with the hoe, you need to click the mouse instead of just holding the button
        // This should prevent people from accidentally killing them right after sowing
        if (state == FarmObjectState.SEED) {
          if (TouchInput.isPressed() && !TouchInput.isTriggered()) {
            return false;
          }
        }
      }

      if (state == Constants.FarmObjectState.NONE) {
        if (!tile.isSoil()) {
          return false;
        }
      } else  {
        tile.farmObject = farmObject;
      }
    }

    return true;
  }

  static isTileValidForMouseDown(tile) {
    return this.isTileValid(tile, true);
  }

  static filterInvalidTiles(basicTiles, includeInvalid = false, useCurrentMousePosition = false) {
    const validTiles = [];

    for (let i = 0; i < basicTiles.length; i++) {
      const tile = basicTiles[i];

      if (!this.isTileValid(tile, useCurrentMousePosition)) {
        continue;
      }

      tile.valid = true;
      validTiles.push(tile);
    }

    return validTiles;
  }

  static getAffectedTiles(level, includeInvalid, useCurrentMousePosition, targetTile = null) {
    if (level === undefined) level = this.level;

    targetTile = targetTile || this.targetTile(useCurrentMousePosition);
    const basicTiles = this.getBasicAffectedTiles(targetTile, level);
    const validTiles = this.filterInvalidTiles(basicTiles, includeInvalid, useCurrentMousePosition);

    return validTiles;
  }

  static isTileBetterThanDefault(x, y) {
    const tile = new TileHelper.Tile(x, y);
    if (!tile) return false;

    const allTiles = this.getBasicAffectedTiles.call(this, tile, 0);
    const validTiles = this.filterInvalidTiles(allTiles);

    if (validTiles.length > 0) {
      return true;
    }

    return false;
  }
};

Managers.Tools.registerTool(Tools.Hoe);