require('game/tools/Tool');

Tools.Barn = class Barn extends Tools.BaseTool {
  static get toolName() {
    return 'barn';
  }

  static doToolEffect(level) {
    if (!$gameMap.isFarm()) return;

    const tileList = this.getAffectedTiles(level, false, false);
    if (tileList.length === 0) return;

    const tile = tileList[0];
    if (!this.validateTile(tile.x, tile.y)) return;

    const barn = Managers.FarmObjects.createBarnAt($gameMap._mapId, tile.x, tile.y);
    barn.updateEvents(true, true);
    Managers.Items.loseItemId(this.toolName);
    $gamePlayer.leaveTile(tile.x, tile.y);

    const anotherTile = TileHelper.getFrontTile(1);
    if (anotherTile) {
      $gamePlayer.leaveTile(anotherTile.x, anotherTile.y);
    }
  }

  static use(level, targetTile = null) {
    if ($gamePlayer) {
      $gamePlayer.delayItemSprite();
    }

    $gamePlayer.doToolDelayAnimation(this.toolName);
    this.doToolEffect(level);
  }

  static validateTile(x, y) {
    const region = TileHelper.getTileRegion(x, y);
    if (region == Region.PROTECTED) return false;
    if (region == Region.SUPER_PROTECTED) return false;
    if (region == Region.SACI) return false;

    return TileHelper.checkIfTileCanGetObject(x, y, true);
  }

  static getAffectedTiles(level, includeInvalid) {
    if ($gameMap.isInside()) return [];

    const tile = TileHelper.getFrontTile(1);
    const tileList = [];

    if (!includeInvalid) {
      if (!this.validateTile(tile.x, tile.y)) return [];
    }

    let nextTile = tile;

    function addTile(tileObj) {
      if (tileObj) {
        tileList.push(tileObj);
      }
    }

    if ($gamePlayer._direction == Direction.DOWN) {
      nextTile = nextTile.tileAtDirection($gamePlayer._direction, 6);
    } else if ($gamePlayer._direction == Direction.LEFT || $gamePlayer._direction == Direction.RIGHT) {
      nextTile = nextTile.tileAtDirection($gamePlayer._direction, 2);
    }

    for (let i = 0; i < 7; i++) {
      if (nextTile === undefined) {
        if (includeInvalid) {
          break;
        }
        return [];
      }

      tileList.push(nextTile);
      addTile(nextTile.tileAtDirection(Direction.LEFT, 1));
      addTile(nextTile.tileAtDirection(Direction.LEFT, 2));
      addTile(nextTile.tileAtDirection(Direction.RIGHT, 1));
      addTile(nextTile.tileAtDirection(Direction.RIGHT, 2));

      nextTile = nextTile.tileAtDirection(Direction.UP);
    }

    for (let j = 0; j < tileList.length; j++) {
      if (!this.validateTile(tileList[j].x, tileList[j].y)) {
        if (!includeInvalid) return [];
        tileList[j].valid = false;
      } else {
        tileList[j].valid = true;
      }
    }

    return tileList;
  }
};

Managers.Tools.registerTool(Tools.Barn);