require('game/tools/Tool');

Tools.Axe = class BaseAxe extends Tools.BaseTool {
  static get spriteName() {
    return 'metal_tools[4]_iron';
  }

  static get spriteIndex() {
    return 0;
  }

  static get energyRequired() {
    return 5;
  }

  static giveBranch(amount, x, y) {
    if (!Managers.Items.tryPickItemId('branch', amount)) {
      Managers.FarmObjects.createItemAt($gameMap._mapId, x, y, 'branch', amount);
    }
  }

  static checkStumpStatus(stump) {
    let amount = 1;

    if (stump.modelName == FarmObjectState.STUMP) {
      amount = 3;
    } else if (stump.modelName == FarmObjectState.FALLEN_TREE) {
      amount = 10;
    }

    if (stump.hp <= 1) {
      stump.hp = 1;

      $gameTemp.setTimeout(() => {
        const customClear = Managers.Content.onClearObject(stump);

        if (customClear === false) {
          return;
        }

        const { x, y } = stump;

        stump.clear();
        stump.updateEvents();

        if (customClear === true) {
          return;
        }

        $gameTemp.setTimeout(() => {
          this.giveBranch(amount, x, y);
        }, 12);
      }, 3);
    }
  }

  static checkTreeStatus(tree) {
    const amount = 10;

    if (tree.hp <= 1) {
      tree.hp = 1;

      $gameTemp.setTimeout(() => {
        tree.modelName = FarmObjectState.STUMP;
        tree.hp = 5;
        tree.updateEvents();

        $gameTemp.setTimeout(() => {
          this.giveBranch(amount, tree.x, tree.y);
        }, 12);
      }, 3);
    }
  }

  static doToolEffect(level, targetTile = null) {
    const tiles = this.getAffectedTiles(level, true, TouchInput.wasMouseUsed(), targetTile);

    for (let i = 0; i < tiles.length; i++) {
      const tile = tiles[i];
      if (!tile.valid) {
        Managers.Sound.playAxe();
        continue;
      }

      const farmObjects = Managers.FarmObjects.getFarmObjectsXy($gameMap._mapId, tile.x, tile.y);
      for (let j = 0; j < farmObjects.length; j++) {
        const farmObject = farmObjects[j];

        if (farmObject.modelName == FarmObjectState.STUMP || farmObject.modelName == FarmObjectState.LOG || farmObject.modelName == FarmObjectState.FALLEN_TREE) {
          if (farmObject.hp === undefined) {
            if (farmObject.modelName == FarmObjectState.FALLEN_TREE) {
              farmObject.hp = 7;
            } else {
              farmObject.hp = 5;
            }
          }

          // farmObject.playAnimation(Constants.STUMP_ANIMATION_ID);
          farmObject.hp--;
          this.checkStumpStatus(farmObject);
          Managers.Player.woodcuttingExp++;

          let newLevel = level;
          let newHp = farmObject.hp;
          let waitTime = 3;

          if (farmObject.modelName == FarmObjectState.FALLEN_TREE) {
            if (farmObject.hp >= 6) {
              newLevel = 0;
            } else {
              newLevel = 5;
            }
          }

          if (farmObject.modelName == FarmObjectState.STUMP && newLevel < 3) {
            newLevel--;
          }

          if (farmObject.modelName == FarmObjectState.LOG && newLevel == 2) {
            newLevel++;
          }

          while ((newLevel > 0 || newHp < 3) && newHp > 1) {
            newHp--;
            newLevel--;

            Managers.Player.woodcuttingExp++;

            if (newHp > 1) {
              $gameTemp.setTimeout(() => { // jshint ignore:line
                farmObject.hp--;
                if (newHp >= 3) {
                  this.affectHealth(0);
                }
                farmObject.updateEvents();
              }, waitTime);
              waitTime += 3;
            } else {
              $gameTemp.setTimeout(() => { //jshint ignore:line
                farmObject.hp = 1;
                newLevel = 0;
                this.checkStumpStatus(farmObject);
              }, waitTime);
            }
          }

          this.affectHealth(0);
          Managers.Sound.playAxe();
          farmObject.updateEvents();
          break;
        } else if (farmObject.isCuttableTree()) {
          if ($gameMap.isFarm() || $gameMap.regionId(farmObject.x, farmObject.y) == Region.FARM) {
            if (farmObject.hp === undefined) farmObject.hp = 12;

            // farmObject.playAnimation(Constants.STUMP_ANIMATION_ID);
            farmObject.hp--;
            Managers.Player.woodcuttingExp++;

            let toolLevel = level - 2;
            while (toolLevel > 0 && farmObject.hp > 0) {
              farmObject.hp--;
              toolLevel--;
              Managers.Player.woodcuttingExp++;
              this.affectHealth(0);
            }

            this.checkTreeStatus(farmObject);

            this.affectHealth(0);
            Managers.Sound.playAxe();
            farmObject.updateEvents();
          } else {
            continue;
          }


        } else {
          continue;
        }
      }
    }

    Managers.FarmObjects.clearEmptyItems();
  }

  static use(level, targetTile = null) {
    level = Managers.Tools.getMaxToolLevel();

    this.doAnimation();
    const oldStaminaLevel = Managers.Health.staminaLevel;

    if (targetTile) {
      $gamePlayer.turnTowardPosition(targetTile.x, targetTile.y);
    }

    this.affectHealth(0);
    // this.affectHealth(level);
    setTimeout(() => {
      Managers.Sound.playSwing();
      this.doToolEffect(level, targetTile);
      Managers.Health.oldStaminaLevel = oldStaminaLevel;
    }, this.effectDelay);
  }

  static filterInvalidTiles(basicTiles) {
    const validTiles = [];
    const maxLevel = this.level;
    const heightLevel = $gamePlayer.getHeightLevel();

    for (let i = 0; i < basicTiles.length; i++) {
      const tile = basicTiles[i];

      if (Managers.Map.getHeightLevel(tile.x, tile.y) != heightLevel) continue;

      tile.valid = true;
      const farmObjects = Managers.FarmObjects.getFarmObjectsXy($gameMap._mapId, tile.x, tile.y);
      for (let j = 0; j < farmObjects.length; j++) {
        const farmObject = farmObjects[j];

        if (farmObject === undefined) continue;

        const state = farmObject.state;
        let isTree = false;
        const validStates = [FarmObjectState.LOG, FarmObjectState.STUMP, FarmObjectState.FALLEN_TREE];
        if (validStates.indexOf(state) < 0) {
          if (!farmObject.isCuttableTree()) continue;
          isTree = true;
        }

        if (isTree) {
          if (!$gameMap.isFarm() && $gameMap.regionId(farmObject.x, farmObject.y) != Region.FARM) {
            continue;
          }

          if (maxLevel < 2) {
            tile.valid = false;
          }
        } else if (state == FarmObjectState.STUMP) {
          if (maxLevel < 1) {
            tile.valid = false;
          }
        } else if (state == FarmObjectState.FALLEN_TREE) {
          if (maxLevel < 3) {
            tile.valid = false;
          }
        }

        tile.farmObject = farmObject;
        validTiles.push(tile);
        break;
      }
    }

    return validTiles;
  }

  static getAffectedTiles(level, includeInvalid, useCurrentMousePosition, targetTile = null) {
    if (level === undefined) level = this.level;

    const initialTile = targetTile || this.targetTile(useCurrentMousePosition);
    const allTiles = this.getBasicAffectedTiles(initialTile, level);

    const validTiles = this.filterInvalidTiles(allTiles);

    return validTiles;
  }

  static isTileBetterThanDefault(x, y) {
    return this.checkIfTileIsBetterThanDefault(x, y);
  }

  static shouldBeUsedOnEvent(event) {
    const farmObjectData = event._farmObjectData;
    const modelName = farmObjectData.modelName;

    if (modelName == FarmObjectState.LOG || modelName == FarmObjectState.STUMP || modelName == FarmObjectState.FALLEN_TREE) {
      if (modelName == FarmObjectState.STUMP) {
        const toolLevel = Managers.Tools.toolLevel;
        if (toolLevel === 0) {
          return false;
        }
      }

      if (modelName == FarmObjectState.FALLEN_TREE) {
        const toolLevel = Managers.Tools.toolLevel;
        if (toolLevel < 3) {
          return false;
        }
      }

      return true;
    }

    if (modelName.endsWith('-tree') || modelName.endsWith('-crop')) {
      if (farmObjectData.isCuttableTree()) {
        if ($gameMap.isFarm() || $gameMap.regionId(event.x, event.y) == Region.FARM) {
          return true;
        }
      }
    }

    return false;
  }
};

Managers.Tools.registerTool(Tools.Axe);