require('game/tools/Tool');

Tools.Milker = class Milker extends Tools.BaseTool {
  static get spriteName() {
    return '';
  }

  static get spriteIndex() {
    return 0;
  }

  static get level() {
    return 0;
  }

  static get toolName() {
    return 'milker';
  }

  static get energyRequired() {
    return 1;
  }

  static use(level, targetTile = null) {
    $gamePlayer.endToolAnimation();

    let tile = targetTile;

    if (!tile) {
      if (TouchInput.wasMouseClickedRecently()) {
        const x = $gameMap.canvasToMapX(TouchInput.mouseX);
        const y = $gameMap.canvasToMapY(TouchInput.mouseY);
        tile = TileHelper.newTile(x, y);
      } else {
        tile = TileHelper.getFrontTile(1);
      }
    }

    if (!tile) return false;

    const creatures = $gameMap.creaturesXy(tile.x, tile.y);
    if (creatures) {
      if (!creatures || !creatures.length) return false;

      const eventData = creatures[0];
      return this.useMilkerOnEvent(eventData);
    }

    return false;
  }

  static useAtEvent(event) {
    return this.useMilkerOnEvent(event);
  }

  static useMilkerOnEvent(eventData) {
    const distance = eventData.distanceToPlayer();
    if (distance > eventData.maxActivationDistance()) {
      return false;
    }

    const creature = eventData._creatureData;
    if (!creature) return false;

    const type = creature.getCreatureType();
    if (!type) return false;
    if (!type.getMilkItemId) return false;

    if (creature.milked) {
      return false;
    }

    this.milkAnimal(eventData);
    return true;
  }

  static milkAnimal(animalEvent) {
    const creature = animalEvent._creatureData;
    const type = creature.getCreatureType();
    const itemId = type.getMilkItemId();

    if (!Managers.Items.canGainItemId(itemId)) {
      Managers.CommonEvent.playEvent('no_space_to_milk');
      return;
    }

    creature.milked = true;
    creature.hasMilk = false;

    animalEvent.storeCreatureDataOnVariables();
    Managers.CommonEvent.playEvent('play_animal_balloon');
    Managers.Items.pickItemId(itemId);
  }

  static getAffectedTiles(level, includeInvalid) {
    return [];
  }
};

Managers.Tools.registerTool(Tools.Milker);