require('game/tools/Tool');

Tools.Clippers = class Clippers extends Tools.BaseTool {
  static get spriteName() {
    return '';
  }

  static get spriteIndex() {
    return 0;
  }

  static get level() {
    return 0;
  }

  static get toolName() {
    return 'clippers';
  }

  static get energyRequired() {
    return 1;
  }

  static use(level, targetTile = null) {
    $gamePlayer.endToolAnimation();

    let tile = targetTile;

    if (!tile) {
      if (TouchInput.wasMouseClickedRecently()) {
        const x = $gameMap.canvasToMapX(TouchInput.mouseX);
        const y = $gameMap.canvasToMapY(TouchInput.mouseY);
        tile = TileHelper.newTile(x, y);
      } else {
        tile = TileHelper.getFrontTile(1);
      }
    }

    if (!tile) return false;

    const creatures = $gameMap.creaturesXy(tile.x, tile.y);
    if (creatures) {
      if (!creatures || !creatures.length) return false;

      const eventData = creatures[0];
      return this.useClippersOnEvent(eventData);
    }

    return false;
  }

  static useAtEvent(event) {
    return this.useClippersOnEvent(event);
  }

  static useClippersOnEvent(eventData) {
    const distance = eventData.distanceToPlayer();
    if (distance > eventData.maxActivationDistance()) {
      return false;
    }

    const creature = eventData._creatureData;
    if (!creature) return false;

    const type = creature.getCreatureType();
    if (!type) return false;
    if (!type.getWoolItemId) return false;

    if (creature.sheared) {
      return false;
    }

    this.shearAnimal(eventData);
    return true;
  }

  static shearAnimal(animalEvent) {
    const creature = animalEvent._creatureData;
    const type = creature.getCreatureType();
    const itemId = type.getWoolItemId();

    if (!Managers.Items.canGainItemId(itemId)) {
      Managers.CommonEvent.playEvent('no_space_to_wool');
      return;
    }

    creature.sheared = true;
    creature.hasWool = false;
    creature.woolDays = 0;

    animalEvent.storeCreatureDataOnVariables();
    Managers.CommonEvent.playEvent('play_animal_balloon');
    Managers.Items.pickItemId(itemId);
  }

  static getAffectedTiles(level, includeInvalid) {
    return [];
  }
};

Managers.Tools.registerTool(Tools.Clippers);