require('game/tools/Tool');

Tools.AnimalTools = class AnimalTools extends Tools.BaseTool {
  static get spriteName() {
    return '';
  }

  static get spriteIndex() {
    return 0;
  }

  static get level() {
    return 0;
  }

  static get toolName() {
    return 'animal-tools';
  }

  static get energyRequired() {
    return 1;
  }
  
  static getAffectedTiles(level, includeInvalid) {
    return [];
  }

  static use(level, targetTile = null) {
    $gamePlayer.endToolAnimation();

    let tile = targetTile;

    if (!tile) {
      if (TouchInput.wasMouseClickedRecently()) {
        const x = $gameMap.canvasToMapX(TouchInput.mouseX);
        const y = $gameMap.canvasToMapY(TouchInput.mouseY);
        tile = TileHelper.newTile(x, y);
      } else {
        tile = TileHelper.getFrontTile(1);
      }
    }

    if (!tile) return false;

    const creatures = $gameMap.creaturesXy(tile.x, tile.y);
    if (creatures) {
      if (!creatures || !creatures.length) return false;

      return this.useAtEvent(creatures[0]);
    }

    return false;
  }

  static useAtEvent(event) {
    const creature = event._creatureData;
    if (!creature) {
      return false;
    }

    const type = creature.getCreatureType();
    if (!type) {
      return false;
    }

    if (type.getMilkItemId) {
      return this.useMilkerOnEvent(event);
    }

    if (type.getWoolItemId) {
      return this.useClippersOnEvent(event);
    }

    return false;
  }

  static useMilkerOnEvent(event) {
    return Tools.Milker.useMilkerOnEvent(event);
  }

  static useClippersOnEvent(event) {
    return Tools.Clippers.useClippersOnEvent(event);
  }
};

Managers.Tools.registerTool(Tools.AnimalTools);