require('game/managers/Tools');

Tools.BaseTool = class {
  static get spriteName() {
    return '';
  }

  static get spriteIndex() {
    return 0;
  }

  static get level() {
    return 0;
  }

  static get toolName() {
    return '';
  }

  static get usageDistance() {
    return 1;
  }

  static get energyRequired() {
    return 5;
  }

  static get fatigueRequired() {
    return 0.4;
  }

  static get effectDelay() {
    return Utils.getFrameCount(200);
  }

  static callToolAnimation() {
    $gamePlayer.doToolAnimation(this.toolName);
  }

  static doCustomAnimation(animationCall) {
    const spriteBitmap = this.preloadSprite();

    if (spriteBitmap) {
      spriteBitmap.addLoadListener(() => {
        animationCall();
      });

      return;
    }

    animationCall();
  }

  static doAnimation() {
    this.doCustomAnimation(() => {
      this.callToolAnimation();
    });
  }

  static preloadSprite() {
    if (this.spriteName) {
      const spriteName = `${ Managers.Player.generatePlayerSpriteName() }_${ this.spriteName }`;
      return Managers.Images.loadCharacter(spriteName);
    }
  }

  static use(level, targetTile = null) {
    this.doAnimation();
  }

  static getSpriteName(toolState) {
    return this.spriteName;
  }

  static getSpriteIndex(toolState) {
    return this.spriteIndex;
  }

  static getBasicAffectedTiles(initialTile, level) {
    if (initialTile) {
      initialTile.valid = true;
      return [initialTile];
    }

    return [];
  }

  static targetTile(useCurrentMousePosition) {
    if (Managers.Tools.targetTile) {
      return Managers.Tools.targetTile;
    }

    if (TouchInput.wasMouseUsed()) {
      let x = -100;
      let y = -100;

      if (useCurrentMousePosition) {
        x = $gameMap.canvasToMapX(TouchInput.mouseX);
        y = $gameMap.canvasToMapY(TouchInput.mouseY);
      } else {
        x = $gameMap.canvasToMapX(TouchInput.rightX);
        y = $gameMap.canvasToMapY(TouchInput.rightY);
      }

      if (Managers.Tools.isTileBetterThanDefault(x, y)) {
        const newTile = TileHelper.newTile(x, y);
        if (newTile) return newTile;
      }
    }

    return this.getFrontTile();
  }

  static getFrontTile() {
    return TileHelper.getSmartFrontTile(this.usageDistance);
  }

  static getAffectedTiles(level, includeInvalid) {
    const tile = TileHelper.getSmartFrontTile(this.usageDistance);
    return this.getBasicAffectedTiles(tile, level);
  }

  static checkIfTileIsBetterThanDefault(x, y) {
    const tile = new TileHelper.Tile(x, y);
    if (!tile) return false;

    const allTiles = this.getBasicAffectedTiles.call(this, tile, 0);
    const validTiles = this.filterInvalidTiles(allTiles);

    if (validTiles.length > 0) {
      return true;
    }

    return false;
  }

  static filterInvalidTiles(allTiles) {
    return allTiles;
  }

  static isTileBetterThanDefault(x, y) {
    return false;
  }

  static removeFromInventory(amount) {
    if (amount === undefined) {
      amount = 1;
    }

    Managers.Items.loseItemId(this.toolName, amount);
  }

  static affectHealth(level) {
    Managers.Health.doToolUsageEffect(this, level);
  }

  static shouldBeUsedOnEvent(event) {
    return false;
  }

  static isTileValid(tile, usingMouse = false) {
    return true;
  }

  // This method is considered only for empty tiles, as objects are handled elsewhere
  static isTileValidForMouseDown(tile) {
    return false;
  }
};