require('game/tools/Tool');
require('game/managers/Tools');

Tools.Seed = class Seed extends Tools.BaseTool {
  static get cropName() {
    return '';
  }

  static get energyRequired() {
    return 1;
  }

  static doAnimation() {
    $gamePlayer.doToolDelayAnimation(this.toolName, 10);
  }

  static use(level, targetTile = null) {
    this.doAnimation();

    const tiles = (targetTile && this.canTileBeTargeted(targetTile)) ? [targetTile] : this.getAffectedTiles(level, false, false);
    if (tiles.length === 0) {
      return false;
    }

    setTimeout(() => {
      if (this.doToolEffect(tiles)) {
        Managers.Items.loseItemId(this.toolName);
        $gameTemp.requestAffectedTilesRefresh();
        this.affectHealth();
      }
    }, this.effectDelay);

    return true;
  }

  static doToolEffect(tiles) {
    tiles = tiles || this.getAffectedTiles(0, false, false);
    const len = tiles.length;

    let changedAny = false;

    for (let i = 0; i < len; i++) {
      const tile = tiles[i];
      if (!tile) {
        continue;
      }

      const farmObject = Managers.FarmObjects.getFarmObject($gameMap._mapId, tile.x, tile.y);
      if (!farmObject) {
        continue;
      }

      if (farmObject.modelName) {
        continue;
      }

      farmObject.modelName = `${ this.cropName }-crop`;
      farmObject.points = 0;
      farmObject.stage = 0;
      farmObject.age = 0;
      farmObject.spoiled = false;
      farmObject.lastFruit = false;
      farmObject.updateEvents(true);
      changedAny = true;
      Managers.Sound.playSeed();
    }

    return changedAny;
  }

  static canTileBeTargeted(tile) {
    if (!tile) {
      return false;
    }

    if (!Managers.FarmObjects.isTileTilled($gameMap._mapId, tile.x, tile.y)) {
      return false;
    }

    if (!TileHelper.checkIfTileCanGetObject(tile.x, tile.y, true, 'seeds', false, false)) {
      return;
    }

    return true;
  }

  static getAffectedTiles(level, includeInvalid, useCurrentMousePosition) {
    const tiles = [];
    const direction = $gamePlayer.direction();
    const maxTiles = 9;

    const addTile = (tile) => {
      if (tiles.length >= maxTiles) return false;
      if (!this.canTileBeTargeted(tile)) return false;

      tile.valid = true;
      tile.farmObject = Managers.FarmObjects.getFarmObject($gameMap._mapId, tile.x, tile.y);
      tiles.push(tile);
      return true;
    };

    const currentTile = this.targetTile(useCurrentMousePosition);
    if (!currentTile) return [];

    if (addTile(currentTile)) return tiles;

    const sideTile = TileHelper.getAlternativeFrontTile(currentTile);
    if (addTile(sideTile)) return tiles;

    if (addTile(currentTile.tileAtDirection(direction))) return tiles;
    if (sideTile) {
      if (addTile(sideTile.tileAtDirection(direction))) return tiles;
    }

    return tiles;
  }

  static isTileBetterThanDefault(x, y) {
    return this.checkIfTileIsBetterThanDefault(x, y);
  }

  static filterInvalidTiles(tiles) {
    const validTiles = [];
    const heightLevel = $gamePlayer.getHeightLevel();

    for (let i = 0; i < tiles.length; i++) {
      const tile = tiles[i];

      if (!tile) continue;

      if (Managers.Map.getHeightLevel(tile.x, tile.y) != heightLevel) continue;

      if (!Managers.FarmObjects.isTileTilled($gameMap._mapId, tile.x, tile.y)) {
        continue;
      }

      const farmObject = Managers.FarmObjects.getFarmObject($gameMap._mapId, tile.x, tile.y);

      if (farmObject) {
        tile.valid = true;
        tile.farmObject = farmObject;
        validTiles.push(tile);
        break;
      }
    }

    return validTiles;
  }

  static shouldBeUsedOnEvent(event) {
    const farmObjectData = event._farmObjectData;

    if (!farmObjectData.tilled) return false;
    if (farmObjectData.modelName) return false;

    return true;
  }

};
