require('engine/sprites/Sprite_Base');

class Sprite_ObjectInformation extends Sprite_Base {

  initialize() {
    super.initialize();

    this.bitmap = Managers.Images.loadPicture('info_pin');
    this.anchor.x = 0.5;
    this.anchor.y = 0.5;
  }

  update() {
    super.update();

    const data = $gameTemp.getNamedObject();

    if (!data) {
      this.visible = false;
      return;
    }

    if (!$gameTemp.isNamedObjectUpToDate()) {
      this.visible = false;
      return;
    }
    
    this.visible = true;
    this.x = data.displayX;
    this.y = data.displayY;
  }

  updateVisibility() {
  }
}

Sprites.ObjectInformation = Sprite_ObjectInformation;
module.exports = Sprite_ObjectInformation;