//-----------------------------------------------------------------------------
// Sprite_Soil
//
// The sprites of the farmObject soils

class Sprite_Soil extends Sprite_Object {
  constructor(...args) {
    super(...args);
  }

  initialize(farmObject, objectSprite, ...args) {
    super.initialize(farmObject, objectSprite, ...args);
    this.clearSoil();
    this._objectSprite = objectSprite;
    if (objectSprite) {
      objectSprite._soilSprite = this;
    }
  }

  clearSoil() {
    this._characterName = '!crops';
    this._characterIndex = 5;
    this._pattern = 0;
    this._direction = 0;
  }

  update(...args) {
    super.update(...args);
    this.visible = this._direction > 0;
  }

  updateBitmap() {
    if (!$gameTemp.shouldRefreshCropSoils()) return;

    this.clearSoil();

    if (!this.bitmap) {
      this.bitmap = Managers.Images.loadCharacter(this._characterName);
    }

    if (!this._farmObject) return;
    if (!this._farmObject.farmObjectData) return;

    var farmObjectData = this._farmObject.farmObjectData;

    this._characterIndex = 5;
    this._pattern = farmObjectData.watered ? 1 : 0;

    this._direction = 0;

    if (farmObjectData.tilled) {
      if (farmObjectData.isCropOrTree) {
        if (farmObjectData.stage > 0) {
          if (!farmObjectData.isTree()) {
            this._direction = 4;
          }
        }
      }
    }
  }

  updateFrame() {
    if (this.bitmap) {
      this.updateCharacterFrame();
    }
  }

  farmObjectBlockX() {
    return this._characterIndex % 4 * 3;
  }

  farmObjectBlockY() {
    return Math.floor(this._characterIndex / 4) * 4;
  }

  farmObjectPatternX() {
    return this._pattern;
  }

  farmObjectPatternY() {
    return (this._direction - 2) / 2;
  }

  patternWidth() {
    if (this._direction > 0) {
      return this.bitmap.width / 12;
    }

    return 0;
  }

  patternHeight() {
    return this.bitmap.height / 8;
  }

  updatePosition() {
    this.x = this._farmObject.screenX();
    this.y = this._farmObject.screenY();
    this.z = 1;
    this.zIndex = 1;
    this.zOrder = 0;
  }

  canShowOutline() {
    return false;
  }

  assignSpriteToObject(object) {
    object._soilSprite = this;
  }
}

Sprites.Soil = Sprite_Soil;
module.exports = Sprite_Soil;
