require('engine/sprites/Sprite_Object');

//-----------------------------------------------------------------------------
// Sprite_Shadow
//
// The sprites of the farmObject shadows

class Sprite_Shadow extends Sprite_Object {
  constructor(...args) {
    super(...args);
  }

  initialize(farmObject, ...args) {
    super.initialize(farmObject, ...args);
  }

  canShowOutline() {
    return false;
  }

  updateShader() {
  }

  updateAnimation() {

  }

  updateBalloon() {

  }

  setFarmObjectBitmap() {
    if (!this._characterName) {
      return;
    }

    super.setFarmObjectBitmap();
  }

  updateBitmap() {
    if (this.isImageChanged()) {
      this._tilesetId = $gameMap.tilesetId();
      this._tileId = 0;
      this._iconIndex = 0;

      this.setFarmObjectBitmap();
      this._hasFrame = false;

      if (this._changedBitmap) {
        this.longCache = {};
      }
    }
  }

  isAbovePlayerRadius(playerSprite) {
    return false;
  }

  isImageChanged() {
    if (this._characterIndex !== this._oldCharacterIndex) return true;
    if (this._characterName !== this._oldCharacterName) return true;
    return false;
  }

  refresh() {
    super.refresh();
    this._oldCharacterName = this._characterName;
    this._oldCharacterIndex = this._characterIndex;
  }

  isImageDetailsChanged() {
    return false;
  }

  getFarmObjectPriorityType() {
    return 0;
  }

  getFarmObjectScreenZ() {
    return 1;
  }

  assignSpriteToObject(object) {
    object._shadowSprite = this;
  }
}

Sprites.Shadow = Sprite_Shadow;
module.exports = Sprite_Shadow;
