//-----------------------------------------------------------------------------
// Sprite_Sprinkler
//
// The sprite for displaying sprinklers.

function Sprite_Sprinkler() {
  this.initialize.apply(this, arguments);
}

Sprite_Sprinkler.prototype = Object.create(Sprite_Object.prototype);
Sprite_Sprinkler.prototype.constructor = Sprite_Sprinkler;

Sprite_Sprinkler.prototype.update = function() {
  Sprite_Object.prototype.update.call(this);

  if (!this._direction) {
    if (!this._farmObject) return;

    this._direction = this._farmObject.direction();
    this._directionChangeDelay = Utils.getFrameCount(6);
  }

  if (this._directionChangeDelay > 0) {
    this._directionChangeDelay--;
  } else {
    this._direction += 2;
    if (this._direction > 8) {
      this._direction = 2;
    }

    this._directionChangeDelay = Utils.getFrameCount(6);
  }
};

Sprite_Sprinkler.prototype.direction = function() {
  return this._direction || 2;
};

Sprite_Sprinkler.prototype.isImageDetailsChanged = function() {
  if (this._directionChangeDelay == 0) {
    return true;
  }
  return false;
};

//Disable shaders on sprinklers
Sprite_Sprinkler.prototype.updateShader = function() {
};