//-----------------------------------------------------------------------------
// Sprite_PlayerRiding
//
// The sprite for displaying the player's sprite while riding an animal

function Sprite_PlayerRiding() {
  this.initialize.apply(this, arguments);
}

Sprite_PlayerRiding.prototype = Object.create(Sprite_Character.prototype);
Sprite_PlayerRiding.prototype.constructor = Sprite_PlayerRiding;

Sprite_PlayerRiding.prototype.initialize = function() {
  Sprite_Base.prototype.initialize.call(this);
  this.initMembers();
};

Sprite_PlayerRiding.prototype.updateVisibility = function() {
  this.visible = Boolean(this.bitmap);
};

Sprite_PlayerRiding.prototype.isTile = function() {
  return false;
};

Sprite_PlayerRiding.prototype.updateBitmap = function() {
  if (this.isImageChanged()) {
    this._characterName = $gamePlayer.getRidingSprite();
    this._characterIndex = 0;

    // this._characterFrameCount = $gamePlayer.getCurrentAnimalSpriteFrameCount();
    this._isRunning = $gamePlayer.isRunning();

    this.setCharacterBitmap();
  }
};

Sprite_PlayerRiding.prototype.isImageChanged = function() {
  return (this._characterName !== $gamePlayer.getRidingSprite() || this._isRunning !== $gamePlayer.isRunning());
};

Sprite_PlayerRiding.prototype.setCharacterBitmap = function() {
  if (!this._characterName) {
    this.bitmap = null;
    this.visible = false;
    return;
  }

  this.updateFrameCount();
  this.bitmap = Managers.Images.loadCharacter(this._characterName);
  this._isBigCharacter = Managers.Images.isBigCharacter(this._characterName);
  
  if (Managers.Images.isSingleImage(this._characterName)) {
    this._isSingleImage = true;
  } else {
    this._isSingleImage = false;
  }

  this._isToolBitmap = false;
};

Sprite_PlayerRiding.prototype.updateFrame = function() {
  this._mirror = false;

  this.updateCharacterFrame();
};

Sprite_PlayerRiding.prototype.characterBlockX = function() {
  return 0;
};

Sprite_PlayerRiding.prototype.characterBlockY = function() {
  return 0;
};

Sprite_PlayerRiding.prototype.pattern = function() {
  return $gamePlayer.pattern();
};

Sprite_PlayerRiding.prototype.characterPatternX = function() {
  return this.pattern();
};

Sprite_PlayerRiding.prototype.characterPatternY = function() {
  var direction = $gamePlayer.direction();

  return (direction - 2) / 2;
};

Sprite_PlayerRiding.prototype.patternWidth = function() {
  if (!this.bitmap) return 0;

  if (this._isSingleImage) {
    return this.bitmap.width;
  }

  if (this._characterFrameCount) {
    if (this._isBigCharacter) {
      return this.bitmap.width / this._characterFrameCount;
    }

    return this.bitmap.width / (this._characterFrameCount * 4);
  }

  if (this._isBigCharacter) {
    return this.bitmap.width / 3;
  }

  return this.bitmap.width / 12;
};

Sprite_PlayerRiding.prototype.patternHeight = function() {
  if (!this.bitmap) return 0;

  if (this._isSingleImage) {
    return this.bitmap.height;
  }

  if (this._isBigCharacter) {
    return this.bitmap.height / 4;
  } else {
    return this.bitmap.height / 8;
  }
};

Sprite_PlayerRiding.prototype.toolYOffset = function() {
  return 0;
};

Sprite_PlayerRiding.prototype.updatePosition = function() {
  // this.x = 0;
  // this.y = 0;
  // this.z = 0;
};

Sprite_PlayerRiding.prototype.updateAnimation = function() {
};

Sprite_PlayerRiding.prototype.setupAnimation = function() {
};

Sprite_PlayerRiding.prototype.updateOther = function() {
  this.opacity = $gamePlayer.opacity();
  this.blendMode = $gamePlayer.blendMode();
};

Sprite_PlayerRiding.prototype.setupBalloon = function() {
};

Sprite_PlayerRiding.prototype.startBalloon = function() {
};

Sprite_PlayerRiding.prototype.updateBalloon = function() {
};

Sprite_PlayerRiding.prototype.endBalloon = function() {
};

Sprite_PlayerRiding.prototype.isBalloonPlaying = function() {
  return false;
};


