//-----------------------------------------------------------------------------
// Sprite_MountedAnimal
//
// The sprite for displaying the player's ride.

function Sprite_MountedAnimal() {
  this.initialize.apply(this, arguments);
}

Sprite_MountedAnimal.prototype = Object.create(Sprite_Character.prototype);
Sprite_MountedAnimal.prototype.constructor = Sprite_MountedAnimal;

Sprite_MountedAnimal.prototype.initialize = function(playerSprite) {
  Sprite_Base.prototype.initialize.call(this);
  this._playerSprite = playerSprite;
  this.initMembers();
};

Sprite_MountedAnimal.prototype.updateVisibility = function() {
  this.visible = Boolean(this.bitmap);
};

Sprite_MountedAnimal.prototype.isTile = function() {
  return false;
};

Sprite_MountedAnimal.prototype.updateBitmap = function() {
  if (this.isImageChanged()) {
    this._characterName = $gamePlayer.getCurrentAnimalSpriteName();
    this._characterIndex = $gamePlayer._animalIndex;
    this.updateFrameCount();

    this.setCharacterBitmap();
  }
};

Sprite_MountedAnimal.prototype.isImageChanged = function() {
  return (this._characterName !== $gamePlayer.getCurrentAnimalSpriteName() || this._characterIndex !== $gamePlayer._animalIndex);
};

Sprite_MountedAnimal.prototype.setCharacterBitmap = function() {
  if (!this._characterName) {
    this.bitmap = null;
    this.visible = false;
    return;
  }

  this.bitmap = Managers.Images.loadCharacter(this._characterName);
  this._isBigCharacter = Managers.Images.isBigCharacter(this._characterName);
  this._isSingleImage = Managers.Images.isSingleImage(this._characterName);

  this._isToolBitmap = false;
};

Sprite_MountedAnimal.prototype.updateFrame = function() {
  this._mirror = false;

  this.updateCharacterFrame();
};

Sprite_MountedAnimal.prototype.characterBlockX = function() {
  if (this._isBigCharacter || this._isSingleImage) {
    return 0;
  } else {
    var index = $gamePlayer._animalIndex;
    var frameCount = this._characterFrameCount || 3;
    return index % 4 * frameCount;
  }
};

Sprite_MountedAnimal.prototype.characterBlockY = function() {
  if (this._isBigCharacter || this._isSingleImage) {
    return 0;
  } else {
    var index = $gamePlayer._animalIndex;
    return Math.floor(index / 4) * 4;
  }
};

Sprite_MountedAnimal.prototype.pattern = function() {
  return $gamePlayer.pattern();
};


Sprite_MountedAnimal.prototype.characterPatternX = function() {
  return this.pattern();
};

Sprite_MountedAnimal.prototype.characterPatternY = function() {
  var direction = $gamePlayer.direction();

  return (direction - 2) / 2;
};

Sprite_MountedAnimal.prototype.patternWidth = function() {
  if (!this.bitmap) return 0;

  if (this._isSingleImage) {
    return this.bitmap.width;
  }

  if (this._characterFrameCount) {
    if (this._isBigCharacter) {
      return this.bitmap.width / this._characterFrameCount;
    }

    return this.bitmap.width / (this._characterFrameCount * 4);
  }

  if (this._isBigCharacter) {
    return this.bitmap.width / 3;
  }

  return this.bitmap.width / 12;
};

Sprite_MountedAnimal.prototype.patternHeight = function() {
  if (!this.bitmap) return 0;

  if (this._isSingleImage) {
    return this.bitmap.height;
  }

  if (this._isBigCharacter) {
    return this.bitmap.height / 4;
  } else {
    return this.bitmap.height / 8;
  }
};

Sprite_MountedAnimal.prototype.toolYOffset = function() {
  return 0;
};

Sprite_MountedAnimal.prototype.updatePosition = function() {
  // this.x = 0;
  // this.y = 0;
  // this.z = 0;
};

Sprite_MountedAnimal.prototype.updateAnimation = function() {
};

Sprite_MountedAnimal.prototype.setupAnimation = function() {
};

Sprite_MountedAnimal.prototype.updateOther = function() {
  this.opacity = $gamePlayer.opacity();
  this.blendMode = $gamePlayer.blendMode();
};

Sprite_MountedAnimal.prototype.setupBalloon = function() {
};

Sprite_MountedAnimal.prototype.startBalloon = function() {
};

Sprite_MountedAnimal.prototype.updateBalloon = function() {
};

Sprite_MountedAnimal.prototype.endBalloon = function() {
};

Sprite_MountedAnimal.prototype.isBalloonPlaying = function() {
  return false;
};


