//-----------------------------------------------------------------------------
// Sprite_ItemIcon
//
// The sprite for displaying an icon.

function Sprite_ItemIcon() {
  this.initialize.apply(this, arguments);
}

Sprite_ItemIcon.prototype = Object.create(Sprite_Icon.prototype);
Sprite_ItemIcon.prototype.constructor = Sprite_ItemIcon;

MVC.accessor(Sprite_ItemIcon.prototype, 'characterName');
MVC.accessor(Sprite_ItemIcon.prototype, 'characterIndex');
MVC.accessor(Sprite_ItemIcon.prototype, 'direction');

Sprite_ItemIcon.prototype.initialize = function() {
  this._characterName = '';
  this._characterIndex = 0;
  this._direction = 2;
  this._lastCharacterName = '';
  this._lastCharacterIndex = 0;
  this._lastDirection = 2;
  this._iconX = 0;
  this._iconY = 0;
  this._animate = false;
  this._animationCount = 0;
  this._animationPattern = 1;
  this._animationDirection = 1;
  Sprite_Icon.prototype.initialize.call(this);
};

Sprite_ItemIcon.prototype.isImageChanged = function() {
  if (this._iconIndex !== this._lastIconIndex) return true;
  if (this._characterName !== this._lastCharacterName) return true;
  if (this._characterIndex !== this._lastCharacterIndex) return true;
  if (this._direction !== this._lastDirection) return true;

  return false;
};

Sprite_ItemIcon.prototype.update = function() {
  let x = -12 + this._iconX;
  let y = -64 + this._iconY;

  if (!!this._characterName && this._characterIndex !== undefined && !!this._direction && this._characterIndex >= 0) {
    x -= 4;
    y -= 4;
  }

  if (this.x !== x) this.x = x;
  if (this.y !== y) this.y = y;

  const changed = this.isImageChanged();
  const animate = this._animate;

  if (!changed) {
    if (!animate) return;
    if (this._animationCount > 0) {
      this._animationCount--;
      return;
    }

    this._animationPattern = (this._animationPattern + this._animationDirection);
    if (this._animationPattern > 2) {
      this._animationPattern = 2;
      this._animationDirection = -1;
    } else if (this._animationPattern < 0) {
      this._animationPattern = 0;
      this._animationDirection = 1;
    }
    this._animationCount = 5;
  }

  if (!animate || changed) {
    this._animationPattern = 1;
    this._animationDirection = 1;
  }

  this.bitmap = null;
  this._lastCharacterIndex = this._characterIndex;
  this._lastCharacterName = this._characterName;
  this._lastDirection = this._direction;
  this._lastIconIndex = this._iconIndex;
  
  if (!!this._characterName && this._characterIndex !== undefined && !!this._direction && this._characterIndex >= 0) {
    this.drawCharacter(this._characterName, this._characterIndex, 0, 0, this._direction);
    return;
  }

  if (this._iconIndex >= 0) {
    this.drawIcon(this._iconIndex);
    return;
  }
};

Sprite_ItemIcon.prototype.drawIcon = function(/*iconIndex*/) {
  this.bitmap = Managers.Images.loadIcon(this._iconIndex);
};

Sprite_ItemIcon.prototype.drawCharacter = function(characterName, characterIndex, x, y, d) {
  const match = characterName.match(/\[(\d*)\]/);
  const frameCount = (match && match.length >= 2) ? parseInt(match[1]) : 3;

  var bitmap = Managers.Images.loadCharacter(characterName);
  var big = Managers.Images.isBigCharacter(characterName);
  var isRow = Managers.Images.isCharacterRow(characterName);
  var pw = bitmap.width / (big ? frameCount : (frameCount * 4));
  var ph = isRow ? bitmap.height : (bitmap.height / (big ? 4 : 8));
  var n = characterIndex;

  if (!bitmap.isReady()) {
    this._lastCharacterName = '';
    return;
  }

  var pattern = this._animationPattern !== undefined ? this._animationPattern : 1;
  var sx = (n % 4 * frameCount + pattern) * pw;
  var sy = ((Math.floor(n / 4) * 4) + (d - 2 ) / 2) * ph;

  var charBitmap = new Bitmap(pw, ph);
  charBitmap.bltImage(bitmap, sx, sy, pw, ph, x, y);
  this.bitmap = charBitmap;
};