require('./Sprite_Balloon');

class Sprite_ItemBalloon extends Sprite_Balloon {
  initialize(...args) {
    super.initialize(...args);
  }

  maxFrameIndex() {
    return 1;
  }

  loadBitmap() {
    this.bitmap = new Bitmap(Constants.BALLOON_WIDTH, Constants.BALLOON_HEIGHT);
  }

  updateFrame() {
    // Instead of changing the frame like the regular balloon, here we redraw
    this.redraw();
  }

  redraw() {
    const balloonsBitmap = Managers.Images.loadSystem('Balloon');
    const frameIndex = this.frameIndex();

    const w = Constants.BALLOON_WIDTH;
    const h = Constants.BALLOON_HEIGHT;
    const sx = frameIndex * w;
    const sy = (this._balloonId - 1) * h;

    this.bitmap.clearRect(0, 0, w, h);
    this.bitmap.blt(balloonsBitmap, sx, sy, w, h, 0, 0, w, h);

    if (this._iconIndex) {
      const icon = Managers.Images.loadIcon(this._iconIndex);
      if (icon) {
        const x = 10;
        const y = frameIndex == 0 ? 13 : 11;

        this.bitmap.blt(icon, 0, 0, icon.width, icon.height, x, y, icon.width, icon.height);
      }
    }
  }

  setup(iconIndex) {
    super.setup(Balloons.QUICK_ITEM, true);
    this._iconIndex = iconIndex;
  }

  end() {
    this._loop = false;
    this._duration = 0;
  }

  update() {
    Sprite_Base.prototype.update.call(this);

    if (this._duration > 0) {
      this._duration--;
    }

    if (this._duration === 0) {
      this._duration = this.getFullBalloonDuration() -1;
    }

    if (this._duration > 0) {
      this.updateFrame();
    }
  }

  waitTime() {
    return 0;
  }

  speed() {
    return 16;
  }
}

Sprites.ItemBalloon = Sprite_ItemBalloon;
module.exports = Sprite_ItemBalloon;