//-----------------------------------------------------------------------------
// Sprite_Icon
//
// The sprite for displaying an icon.

function Sprite_Icon() {
  this.initialize.apply(this, arguments);
}

Sprite_Icon.prototype = Object.create(Sprite.prototype);
Sprite_Icon.prototype.constructor = Sprite_Icon;

Sprite_Icon.prototype.initialize = function() {
  Sprite.prototype.initialize.call(this);
  this._iconIndex = -1;
  this._lastIconIndex = -1;
  this.update();
};

MVC.accessor(Sprite_Icon.prototype, 'iconIndex');

Sprite_Icon.prototype.update = function() {
  if (this._iconIndex == this._lastIconIndex) return;

  this.bitmap = null;
  this._lastIconIndex = this._iconIndex;

  if (this._iconIndex < 0) {
    return;
  }

  this.drawIcon(this._iconIndex);
};

Sprite_Icon.prototype.drawIcon = function(iconIndex) {
  this.bitmap = Managers.Images.loadIcon(iconIndex);
};