//-----------------------------------------------------------------------------
// Sprite_Channel
//
// The sprite for displaying a TV channel

function Sprite_Channel() {
  this.initialize.apply(this, arguments);
}

Sprite_Channel.prototype = Object.create(Sprite_Base.prototype);
Sprite_Channel.prototype.constructor = Sprite_Channel;

Sprite_Channel.prototype.initialize = function() {
  Sprite_Base.prototype.initialize.call(this);
  this.bitmap = undefined;
  this._index = 0;
  this._delay = 0;
  this._tvEvent = undefined;
  this.z = 3;
  this.x = 100;
  this.y = 100;

  this.opacity = 255;
  this.blendMode = 0;
};

Sprite_Channel.prototype.update = function() {
  Sprite_Base.prototype.update.call(this);

  this.updateBitmap();
  if (!this.bitmap) return;

  var maxDelay = 4;
  const channelName = $gameTemp.getCurrentTvChannel();
  if (channelName == 'rain' || channelName == 'sun') {
    if (this._index >= 6 && this._index <= 15) {
      maxDelay = 6;
    }
  }

  if (this._delay >= Utils.getFrameCount(maxDelay)) {
    this._index++;
    this._delay = 0;
  } else {
    this._delay++;
  }

  this.updateFrame();
};

Sprite_Channel.prototype.updatePosition = function() {
  if (!this._tvEvent) return;

  var eventY = this._tvEvent.screenY();

  this.x = this._tvEvent.screenX() - 19;
  this.y = eventY - 46;
  this.z = this._tvEvent.screenZ();

  this.zIndex = this.z;
  this.zOrder = -(eventY + 1);
};

Sprite_Channel.prototype.updateBitmap = function() {
  if (this.bitmap) {
    let maxIndex = 100;

    switch (this._channelName) {
      case 'rain':
        maxIndex = 54;
        break;
      case 'sun':
        maxIndex = 42;
        break;
      case 'heat':
      case 'snow':
      case 'winter_sun':
      case 'storm':
        maxIndex = 34;
        break;
      case 'snowstorm':
        maxIndex = 38;
        break;
      case 'off':
        maxIndex = 4;
        break;
    }

    const contentMaxIndex = Managers.Content.getTvChannelFrameLength(this._channelName);
    if (contentMaxIndex && !isNaN(Number(contentMaxIndex))) {
      maxIndex = Number(contentMaxIndex);
    }

    if (this._index > maxIndex || !$gameTemp.isPlayingTv()) {
      this.bitmap = undefined;
      $gameTemp.setCurrentTvChannel(false);
      return;
    }

    const channelName = $gameTemp.getCurrentTvChannel();
    // If the channel changed to 'off' and the current one is not already ending
    if (channelName === 'off' && this._channelName !== 'off' && this._index < maxIndex - 4) {
      this.bitmap = Managers.Images.loadChannel(channelName);
      this._channelName = channelName;
      this._index = 0;
    }

    this.updatePosition();
  } else {
    if (!$gameTemp.isPlayingTv()) return;

    const channelName = $gameTemp.getCurrentTvChannel();
    this.bitmap = Managers.Images.loadChannel(channelName);
    this._tvEvent = $gameTemp._tvEvent;
    this._channelName = channelName;

    this.updatePosition();

    this._index = -1;
  }
};

Sprite_Channel.prototype.updateFrame = function() {
  var pw = 38;
  var ph = 22;
  
  var sx = this._index % 6 * pw;
  var sy = Math.floor(this._index / 6) * ph;

  this.setFrame(sx, sy, pw, ph);
};