require('engine/sprites/Sprite_Base');
//-----------------------------------------------------------------------------
// Sprite_Balloon
//
// The sprite for displaying a balloon icon.

function Sprite_Balloon() {
  this.initialize.apply(this, arguments);
}

Sprite_Balloon.prototype = Object.create(Sprite_Base.prototype);
Sprite_Balloon.prototype.constructor = Sprite_Balloon;

Sprite_Balloon.prototype.initialize = function() {
  Sprite_Base.prototype.initialize.call(this);
  this.initMembers();
  this.loadBitmap();
};

Sprite_Balloon.prototype.initMembers = function() {
  this._balloonId = 0;
  this._duration = 0;
  this.anchor.x = 0.5;
  this.anchor.y = 1;
  this.z = 7;
  this._loop = false;
};

Object.defineProperties(Sprite_Balloon.prototype, {
  loop: { get: function() { return this._loop; }, configurable: true }
});

Sprite_Balloon.prototype.loadBitmap = function() {
  this.bitmap = Managers.Images.loadSystem('Balloon');
  this.setFrame(0, 0, 0, 0);
};

Sprite_Balloon.prototype.getFullBalloonDuration = function() {
  return (this.maxFrameIndex() + 1) * this.speed() + this.waitTime();
};

Sprite_Balloon.prototype.setup = function(balloonId, loop) {
  this._balloonId = balloonId;
  this._duration = this.getFullBalloonDuration();
  this._loop = loop || false;
};

Sprite_Balloon.prototype.update = function() {
  Sprite_Base.prototype.update.call(this);

  if (this._duration > 0) {
    this._duration--;

    if (this._loop && this._duration === 0) {
      this._duration = this.getFullBalloonDuration();
    }

    if (this._duration > 0) {
      this.updateFrame();
    }
  }
};

Sprite_Balloon.prototype.updateFrame = function() {
  var w = Constants.BALLOON_WIDTH;
  var h = Constants.BALLOON_HEIGHT;
  var sx = this.frameIndex() * w;
  var sy = (this._balloonId - 1) * h;
  this.setFrame(sx, sy, w, h);
};

Sprite_Balloon.prototype.speed = function() {
  return 8;
};

Sprite_Balloon.prototype.waitTime = function() {
  return Utils.getFrameCount(12);
};

Sprite_Balloon.prototype.frameIndex = function() {
  var index = (this._duration - this.waitTime()) / this.speed();
  return this.maxFrameIndex() - Math.max(Math.floor(index), 0);
};

Sprite_Balloon.prototype.maxFrameIndex = function() {
  switch (this._balloonId) {
    case Balloons.EXCLAMATION:
      return 7;
    case Balloons.QUESTION:
      return 7;
    case Balloons.MUSIC:
      return 17;
    case Balloons.HEART:
      return 12;
    case Balloons.ANGER:
      return 17;
    case Balloons.DROP:
      return 7;
    case Balloons.WEB:
      return 16;
    case Balloons.SILENCE:
      return 22;
    case Balloons.LIGHT:
      return 18;
    case Balloons.SLEEP:
      return 16;
    case Balloons.CRY:
      return 15;
    case Balloons.ITEM:
      return 7;
    case Balloons.THINKING:
      return 8;
    case Balloons.QUICK_ITEM:
      return 1;
    case Balloons.FULL_BACKPACK:
      return 14;
    case Balloons.FAILURE:
      return 11;
    case Balloons.TALKING:
      return 20;
    case Balloons.SECRET:
      return 16;
    default:
      return 7;
  }
};

Sprite_Balloon.prototype.isPlaying = function() {
  return this._duration > 0;
};

Sprite_Balloon.prototype.resetAnimation = function() {
  this.setup(this._balloonId, this._loop);
};