const Scene_MenuBase = require('engine/scenes/Scene_MenuBase');

const Window_ShopItemInfo = require('../../windows/shop/ShopItemInfo');
const Window_ShopItem = require('../../windows/shop/ShopItem');
const Window_AnimatedBackground = require('../../windows/diary/AnimatedBackground');

class Scene_ShopItem extends Scene_MenuBase {
  initialize() {
    super.initialize();
    this._delay = Utils.getFrameCount(20);
  }

  selectItem(item) {
    this._infoWindow.setItem(item);

    const price = Managers.Items.getDiscountedBuyPrice(item);
    const ingredients = Managers.Items.getItemIdIngredients(item.id);
    const maxBuy = Managers.Shop.maxBuyNumberForItem(item, price, ingredients);

    this._numberWindow.setup(item, maxBuy, price, ingredients);
    this._numberWindow.show();
    this._numberWindow.activate();
  }

  create() {
    super.create();
    this._inputDelay = Utils.getFrameCount(8);

    this.createBackgroundWindow();
    this.createNumberWindow();
    this.createInfoWindow();

    this._numberWindow.activate();
    this._numberWindow.refresh();
  }

  prepare(itemId) {
    this._itemId = itemId;
    this._item = Managers.Items.getItemData(itemId);
  }

  createBackground() {
    const bitmap = Managers.Scenes.backgroundBitmap();
    if (bitmap) {
      this._backgroundSprite = new Sprite(bitmap);
      this.addChild(this._backgroundSprite);
      this.setBackgroundOpacity(this.backgroundOpacity());
    }
  }

  createBackgroundWindow() {
    if (!this._backgroundSprite) {
      this._bgAnimationWindow = new Window_AnimatedBackground(0, 0, Graphics.width, Graphics.height);
      this.addWindow(this._bgAnimationWindow);
      this._bgAnimationWindow.refresh();
    }
  }

  makeItemList() {
  }

  update() {
    super.update();
    if (this._delay > 0) {
      this._delay--;
    }
  }

  createInfoWindow() {
    const x = this._numberWindow.x + this._numberWindow.width;
    const y = (Graphics.height / 2) - 99 * Graphics.windowZoomLevel;

    this._infoWindow = new Window_ShopItemInfo(x, y);
    this.addWindow(this._infoWindow);
    this._infoWindow.setDiscountInformationEnabled(true);
    this._infoWindow.setItem(this._item);
  }
  
  createNumberWindow() {
    this._numberWindow = new Window_ShopItem();
    this._numberWindow.setHandler('ok', this.onNumberOk.bind(this));
    this._numberWindow.setHandler('cancel', this.onNumberCancel.bind(this));
    this.addWindow(this._numberWindow);

    const item = this._item;
    const price = Managers.Items.getDiscountedBuyPrice(item);
    const ingredients = Managers.Items.getItemIdIngredients(item.id);
    const maxBuy = Managers.Shop.maxBuyNumberForItem(item, price, ingredients);

    this._numberWindow.setup(item, maxBuy, price, ingredients);
  }

  onNumberOk() {
    const item = this._numberWindow.item();
    const number = this._numberWindow.totalNumber();
    const price = Managers.Items.getDiscountedBuyPrice(item);
    const ingredients = Managers.Items.getItemIdIngredients(item.id);
    const maxBuy = Managers.Shop.maxBuyNumberForItem(item, price, ingredients);

    if (maxBuy >= number && Managers.Items.buyItem(item.id, number, price)){
      Managers.Sound.playShop();
      this.popScene();
      return;
    }

    Managers.Sound.playBuzzer();
    this._numberWindow.activate();
  }

  onNumberCancel() {
    if (this._delay > 0) {
      this._numberWindow.activate();
      return;
    }

    this.popScene();
  }
}

GameScenes.ShopItem = Scene_ShopItem;
module.exports = Scene_ShopItem;