const Scene_MenuBase = require('engine/scenes/Scene_MenuBase');
const Window_ShopCommand = require('../../windows/shop/ShopCommand');
const Window_SellAnimals = require('../../windows/shop/SellAnimals');
//-----------------------------------------------------------------------------
// Scene_SellAnimals
//
// The scene class used when the player wants to sell an animal
class Scene_SellAnimals extends Scene_MenuBase {
  prepare() {
    Managers.Images.loadBackground('animal_shop_layout');
    Managers.Images.loadPicture('shop/animal_shop_sell_slot');
  }

  create() {
    super.create();
    this.createAnimalListWindow();
    this.createCloseButton();
    this.createCommandWindow();
  }

  terminate() {
    Managers.Images.releaseBackground('animal_shop_layout');
    Managers.Images.releasePicture('shop/animal_shop_sell_slot');
    super.terminate();
  }

  createCommandWindow() {
    this._commandWindow = new Window_ShopCommand();
    this._commandWindow.setHandler('sell', this.onSellOk.bind(this));
    this._commandWindow.setHandler('cancel', this.onSellCancel.bind(this));
    this._commandWindow.hide();
    this._commandWindow.deactivate();
    this.addWindow(this._commandWindow);

    this._commandWindow.setMode('sell');
  }

  animal() {
    return this._animalListWindow.animal();
  }

  createCloseButton() {
    super.createCloseButton();
    this._closeButtonWindow.x = this._animalListWindow.x + this._animalListWindow.height - this._closeButtonWindow.height - (5 * Graphics.windowZoomLevel);
    this._closeButtonWindow.y = this._animalListWindow.y + (10 * Graphics.windowZoomLevel);
  }

  createBackground() {
    const bitmap = Managers.Scenes.backgroundBitmap();
    if (bitmap == null) {
      this._backgroundSprite = new Sprite(this.loadingBgBitmap());
      this._backgroundSprite.scale.x = this._backgroundSprite.scale.y = this.screenRatio;
      this._backgroundSprite.x = this.backgroundX();
    } else {
      this._backgroundSprite = new Sprite(bitmap);
    }

    this.addChild(this._backgroundSprite);
    this.setBackgroundOpacity(this.backgroundOpacity());
  }

  createAnimalListWindow() {
    this._animalListWindow = new Window_SellAnimals();
    this._animalListWindow.setHandler('ok', this.onAnimalOk.bind(this));
    this._animalListWindow.setHandler('cancel', this.onAnimalCancel.bind(this));
    this.addWindow(this._animalListWindow);
    this._animalListWindow.select(0);
    this.activateAnimalListWindow();
  }

  closeCommandWindow() {
    this._commandWindow.hide();
    this._commandWindow.deactivate();
    this.activateAnimalListWindow();
  }

  onAnimalCancel() {
    Managers.Scenes.pop();
  }

  activateAnimalListWindow() {
    this._animalListWindow.refresh();
    this._animalListWindow.activate();
  }

  onSellOk() {
    const creature = this.animal();
    if (!creature) {
      Managers.Sound.playBuzzer();
      this.closeCommandWindow();
      return;
    }

    Variables.creatureToSell = creature;
    Managers.Sound.playOk();
    Managers.CommonEvent.playEvent('sell_animal');

    this.popScene();
  }

  onSellCancel() {
    this.closeCommandWindow();
  }

  onAnimalOk() {
    const creature = this.animal();
    if (!creature) {
      Managers.Sound.playBuzzer();
      this.activateAnimalListWindow();
      return;
    }

    this._animalListWindow.deactivate();
    this._commandWindow.show();
    this._commandWindow.activate();
    this._commandWindow.select(1);
  }
}

GameScenes.SellAnimals = Scene_SellAnimals;
module.exports = Scene_SellAnimals;