const Scene_ShopItemList = require('./ShopList');

class Scene_OrangeTownGeneralStoreSeeds extends Scene_ShopItemList {
  addSpringCrops() {
    this.addItem('turnip-seed-box');
    this.addItem('potato-seed-box');
    this.addItem('cucumber-seed-box');

    if (Switches.canBuyStrawberrySeeds) {
      this.addItem('strawberry-seed-box');
    }
  }

  addSpringFlowers() {
    this.addItem('jasmine-seed-box');
    this.addItem('pink-daisy-seed-box');
  }

  addSummerCrops() {
    this.addItem('onion-seed-box');
    this.addItem('corn-seed-box');
    this.addItem('tomato-seed-box');

    if (Switches.canBuyChillipepperSeeds) {
      this.addItem('chillipepper-seed-box');
    }

    if (Switches.canBuyCassavaSeeds) {
      this.addItem('cassava-seed-box');
    }

    if (Switches.canBuyGrapeSeeds) {
      this.addItem('grape-seed-box');
    }

    if (Switches.canBuyWatermelonSeeds) {
      this.addItem('watermelon-seed-box');
    }
  }

  addSummerFlowers() {
    this.addItem('yellow-daisy-seed-box');
    this.addItem('sunflower-seed-box');
  }

  addFallCrops() {
    this.addItem('carrot-seed-box');
    this.addItem('eggplant-seed-box');
    this.addItem('sweet-potato-seed-box');

    if (Switches.canBuyBeetSeeds) {
      this.addItem('beet-seed-box');
    }

    if (Switches.canBuyBroccoliSeeds) {
      this.addItem('broccoli-seed-box');
    }

    if (Switches.canBuyPeanutSeeds) {
      this.addItem('peanut-seed-box');
    }

    if (Switches.canBuySpinachSeeds) {
      this.addItem('spinach-seed-box');
    }

    if (Switches.canBuyRadishSeeds) {
      this.addItem('radish-seed-box');
    }

    if (Switches.canBuyBellpepperSeeds) {
      this.addItem('bellpepper-seed-box');
    }

    if (Switches.canBuyPumpkinSeeds) {
      this.addItem('pumpkin-seed-box');
    }
  }

  addFallFlowers() {
    this.addItem('rose-seed-box');
  }

  addWinterCrops() {
    this.addItem('lettuce-seed-box');
    this.addItem('leek-seed-box');
    this.addItem('cauliflower-seed-box');
  }

  addWinterFlowers() {
    this.addItem('white-rose-seed-box');
  }

  addOtherSeeds() {
    this.addItem('sugarcane-seed-box');
    this.addItem('wheat-seed-box');

    if (Switches.canSellMushroomSeeds) {
      this.addItem('mushroom-seed-box');
    }

    this.addItem('daisy-seed-box');
    this.addItem('jasmine-seed-box');
  }

  makeItemList() {
    this._container.clear();
    this.addSpringCrops();
    this.addSpringFlowers();

    const year = Managers.Time.year;
    const month = Managers.Time.month;

    if (year > 1 || month > 1) {
      this.addSummerCrops();
      this.addSummerFlowers();

      if (year > 1 || month > 2) {
        this.addFallCrops();
        this.addFallFlowers();

        if (year > 1 || month > 3) {
          this.addWinterCrops();
          this.addWinterFlowers();
        }
      }
    }

    this.addOtherSeeds();
  }
}

GameScenes.OrangeTownGeneralStoreSeeds = Scene_OrangeTownGeneralStoreSeeds;
module.exports = Scene_OrangeTownGeneralStoreSeeds;